/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.tasks.api.TaskFlagEnum;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTaskSkipper {
    private static final Logger ourLog = LoggerFactory.getLogger(MigrationTaskSkipper.class);

    public static void setDoNothingOnSkippedTasks(Collection<BaseTask> theTasks, String theSkipVersions) {
        if (StringUtils.isBlank((CharSequence)theSkipVersions) || theTasks.isEmpty()) {
            return;
        }
        Set skippedVersionSet = Stream.of(theSkipVersions.split(",")).map(String::trim).map(s -> s.replace("'", "")).map(s -> s.replace("\"", "")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        for (BaseTask task : theTasks) {
            if (!skippedVersionSet.contains(task.getMigrationVersion())) continue;
            ourLog.info("Will skip {}: {}", (Object)task.getMigrationVersion(), (Object)task.getDescription());
            task.addFlag(TaskFlagEnum.DO_NOTHING);
        }
    }
}

