/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.dao;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeToDriverTypeToSqlType;
import com.healthmarketscience.sqlbuilder.AlterTableQuery;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CreateIndexQuery;
import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationQueryBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(MigrationQueryBuilder.class);
    private final DbSpec mySpec;
    private final DbSchema mySchema;
    private final DbTable myTable;
    private final DbColumn myVersionCol;
    private final DbColumn myInstalledRankCol;
    private final DbColumn myDescriptionCol;
    private final DbColumn myTypeCol;
    private final DbColumn myScriptCol;
    private final DbColumn myChecksumCol;
    private final DbColumn myInstalledByCol;
    private final DbColumn myInstalledOnCol;
    private final DbColumn myExecutionTimeCol;
    private final DbColumn mySuccessCol;
    private final DbColumn myResultCol;
    private final String myDeleteAll;
    private final String myHighestKeyQuery;
    private final DriverTypeEnum myDriverType;
    private final String myMigrationTablename;
    private final String myBooleanType;

    public MigrationQueryBuilder(DriverTypeEnum theDriverType, String theMigrationTablename) {
        this.myDriverType = theDriverType;
        this.myMigrationTablename = theMigrationTablename;
        this.mySpec = new DbSpec();
        this.mySchema = this.mySpec.addDefaultSchema();
        this.myTable = this.mySchema.addTable("\"" + theMigrationTablename + "\"");
        this.myInstalledRankCol = this.myTable.addColumn("\"installed_rank\"", 4, null);
        this.myInstalledRankCol.notNull();
        this.myVersionCol = this.myTable.addColumn("\"version\"", 12, Integer.valueOf(50));
        this.myDescriptionCol = this.myTable.addColumn("\"description\"", 12, Integer.valueOf(200));
        this.myDescriptionCol.notNull();
        this.myTypeCol = this.myTable.addColumn("\"type\"", 12, Integer.valueOf(20));
        this.myTypeCol.notNull();
        this.myScriptCol = this.myTable.addColumn("\"script\"", 12, Integer.valueOf(1000));
        this.myScriptCol.notNull();
        this.myChecksumCol = this.myTable.addColumn("\"checksum\"", 4, null);
        this.myInstalledByCol = this.myTable.addColumn("\"installed_by\"", 12, Integer.valueOf(100));
        this.myInstalledByCol.notNull();
        this.myInstalledOnCol = this.myTable.addColumn("\"installed_on\"", 91, null);
        this.myInstalledOnCol.notNull();
        this.myExecutionTimeCol = this.myTable.addColumn("\"execution_time\"", 4, null);
        this.myExecutionTimeCol.notNull();
        this.myBooleanType = ColumnTypeToDriverTypeToSqlType.getColumnTypeToDriverTypeToSqlType().get((Object)ColumnTypeEnum.BOOLEAN).get((Object)theDriverType);
        this.mySuccessCol = this.myTable.addColumn("\"success\"", this.myBooleanType, null);
        this.mySuccessCol.notNull();
        this.myResultCol = this.myTable.addColumn("\"result\"", 12, Integer.valueOf(100));
        this.myDeleteAll = new DeleteQuery((Table)this.myTable).toString();
        this.myHighestKeyQuery = this.buildHighestKeyQuery();
    }

    public String deleteAll() {
        return this.myDeleteAll;
    }

    public String getHighestKeyQuery() {
        return this.myHighestKeyQuery;
    }

    private String buildHighestKeyQuery() {
        return ((SelectQuery)new SelectQuery().addCustomColumns(new Object[]{FunctionCall.max().addColumnParams(new Column[]{this.myInstalledRankCol})}).validate()).toString();
    }

    public String insertPreparedStatement() {
        return ((InsertQuery)new InsertQuery((Table)this.myTable).addPreparedColumns(new Column[]{this.myInstalledRankCol, this.myVersionCol, this.myDescriptionCol, this.myTypeCol, this.myScriptCol, this.myChecksumCol, this.myInstalledByCol, this.myInstalledOnCol, this.myExecutionTimeCol, this.mySuccessCol, this.myResultCol}).validate()).toString();
    }

    public String createTableStatement() {
        return ((CreateTableQuery)new CreateTableQuery((Table)this.myTable, true).validate()).toString();
    }

    public String addResultColumnStatement() {
        return ((AlterTableQuery)new AlterTableQuery((Table)this.myTable).setAddColumn((Column)this.myResultCol).validate()).toString();
    }

    public String createIndexStatement() {
        return ((CreateIndexQuery)((CreateIndexQuery)new CreateIndexQuery((Table)this.myTable, this.myMigrationTablename.toUpperCase() + "_PK_INDEX").setIndexType(CreateIndexQuery.IndexType.UNIQUE).addColumns(new Column[]{this.myInstalledRankCol})).validate()).toString();
    }

    public String findAllQuery() {
        return ((SelectQuery)new SelectQuery().addFromTable((Table)this.myTable).addCondition((Condition)BinaryCondition.notEqualTo((Object)this.myInstalledRankCol, (Object)-1)).addAllColumns().validate()).toString();
    }

    public String deleteLockRecordStatement(Integer theLockPid, String theLockDescription) {
        return ((DeleteQuery)new DeleteQuery((Table)this.myTable).addCondition((Condition)BinaryCondition.equalTo((Object)this.myInstalledRankCol, (Object)theLockPid)).addCondition((Condition)BinaryCondition.equalTo((Object)this.myDescriptionCol, (Object)theLockDescription)).validate()).toString();
    }

    public String findByPidAndNotDescriptionQuery(Integer theLockPid, String theLockDescription) {
        return ((SelectQuery)new SelectQuery().addFromTable((Table)this.myTable).addCondition((Condition)BinaryCondition.equalTo((Object)this.myInstalledRankCol, (Object)theLockPid)).addCondition((Condition)BinaryCondition.notEqualTo((Object)this.myDescriptionCol, (Object)theLockDescription)).addAllColumns().validate()).toString();
    }
}

