/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTypeTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnDriverMappingOverride;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnNameCase;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddColumnTask
extends BaseTableColumnTypeTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddColumnTask.class);

    public static AddColumnTask lowerCase(Set<ColumnDriverMappingOverride> theColumnDriverMappingOverrides) {
        return new AddColumnTask(null, null, ColumnNameCase.ALL_LOWER, theColumnDriverMappingOverrides);
    }

    public AddColumnTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    private AddColumnTask(String theProductVersion, String theSchemaVersion, ColumnNameCase theColumnNameCase, Set<ColumnDriverMappingOverride> theColumnDriverMappingOverrides) {
        super(theProductVersion, theSchemaVersion, theColumnNameCase, theColumnDriverMappingOverrides);
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Add column " + this.getColumnName() + " on table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> columnNames;
        if (this.myCheckForExistingTables && (columnNames = JdbcUtils.getColumnNames(this.getConnectionProperties(), this.getTableName())).contains(this.getColumnName())) {
            this.logInfo(ourLog, "Column {} already exists on table {} - No action performed", this.getColumnName(), this.getTableName());
            return;
        }
        String sql = this.generateSql();
        this.logInfo(ourLog, "Adding column {} of type {} to table {}", this.getColumnName(), this.getSqlType(), this.getTableName());
        this.executeSql(this.getTableName(), sql, new Object[0]);
    }

    String generateSql() {
        String typeStatement = this.getTypeStatement();
        return switch (this.getDriverType()) {
            case DriverTypeEnum.MYSQL_5_7, DriverTypeEnum.MARIADB_10_1 -> "alter table " + this.getTableName() + " add column `" + this.getColumnName() + "` " + typeStatement + this.buildDefaultClauseIfApplicable();
            case DriverTypeEnum.DERBY_EMBEDDED, DriverTypeEnum.POSTGRES_9_4, DriverTypeEnum.COCKROACHDB_21_1 -> "alter table " + this.getTableName() + " add column " + this.getColumnName() + " " + typeStatement + this.buildDefaultClauseIfApplicable();
            case DriverTypeEnum.MSSQL_2012, DriverTypeEnum.ORACLE_12C, DriverTypeEnum.H2_EMBEDDED -> "alter table " + this.getTableName() + " add " + this.getColumnName() + " " + typeStatement + this.buildDefaultClauseIfApplicable();
            default -> throw new IllegalStateException(Msg.code((int)60));
        };
    }

    @Nonnull
    private String buildDefaultClauseIfApplicable() {
        return this.buildString(this.getDefaultValue(), obj -> " default " + String.valueOf(obj), "");
    }

    public String getTypeStatement() {
        String type = this.getSqlType();
        String nullable = this.getSqlNotNull();
        if (this.isNullable()) {
            nullable = "";
        }
        if (this.myPrettyPrint) {
            nullable = nullable.trim();
        }
        String space = this.isNullable() ? "" : " ";
        return type + space + nullable;
    }
}

