/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.MetadataSource;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddIndexTask
extends BaseTableTask {
    static final Logger ourLog = LoggerFactory.getLogger(AddIndexTask.class);
    private String myIndexName;
    private List<String> myColumns;
    private List<String> myNullableColumns;
    private Boolean myUnique = false;
    private List<String> myIncludeColumns = Collections.emptyList();
    private boolean myOnline;
    private MetadataSource myMetadataSource = new MetadataSource();

    public AddIndexTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    public void setIndexName(String theIndexName) {
        this.myIndexName = theIndexName.toUpperCase(Locale.US);
    }

    public void setColumns(List<String> theColumns) {
        this.myColumns = theColumns;
    }

    public void setUnique(boolean theUnique) {
        this.myUnique = theUnique;
    }

    public List<String> getNullableColumns() {
        return this.myNullableColumns;
    }

    public void setNullableColumns(List<String> theNullableColumns) {
        this.myNullableColumns = theNullableColumns;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notBlank((CharSequence)this.myIndexName, (String)"Index name not specified", (Object[])new Object[0]);
        Validate.isTrue((!this.myColumns.isEmpty() ? 1 : 0) != 0, (String)("Columns not specified for AddIndexTask " + this.myIndexName + " on table " + this.getTableName()), (Object[])new Object[0]);
        Validate.notNull((Object)this.myUnique, (String)"Uniqueness not specified", (Object[])new Object[0]);
        this.setDescription("Add " + this.myIndexName + " index to table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> indexNames = JdbcUtils.getIndexNames(this.getConnectionProperties(), this.getTableName());
        if (indexNames.contains(this.myIndexName)) {
            this.logInfo(ourLog, "Index {} already exists on table {} - No action performed", this.myIndexName, this.getTableName());
            return;
        }
        this.logInfo(ourLog, "Going to add a {} index named {} on table {} for columns {}", this.myUnique != false ? "UNIQUE" : "NON-UNIQUE", this.myIndexName, this.getTableName(), this.myColumns);
        String sql = this.generateSql();
        String tableName = this.getTableName();
        try {
            this.executeSql(tableName, sql, new Object[0]);
        }
        catch (Exception e) {
            String message = e.toString();
            if (message.contains("already exists") || message.contains("already indexed")) {
                ourLog.warn("Index {} already exists: {}", (Object)this.myIndexName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Nonnull
    String generateSql() {
        String unique = this.myUnique != false ? "unique " : "";
        String columns = String.join((CharSequence)", ", this.myColumns);
        Object includeClause = "";
        String mssqlWhereClause = "";
        if (!this.myIncludeColumns.isEmpty()) {
            switch (this.getDriverType()) {
                case POSTGRES_9_4: 
                case MSSQL_2012: 
                case COCKROACHDB_21_1: {
                    includeClause = " INCLUDE (" + String.join((CharSequence)", ", this.myIncludeColumns) + ")";
                    break;
                }
            }
        }
        if (this.myUnique.booleanValue() && this.getDriverType() == DriverTypeEnum.MSSQL_2012) {
            mssqlWhereClause = this.buildMSSqlNotNullWhereClause();
        }
        String postgresOnlineClause = "";
        String oracleOnlineClause = "";
        if (this.myOnline) {
            switch (this.getDriverType()) {
                case POSTGRES_9_4: 
                case COCKROACHDB_21_1: {
                    postgresOnlineClause = "CONCURRENTLY ";
                    this.setTransactional(false);
                    break;
                }
                case MSSQL_2012: {
                    break;
                }
                case ORACLE_12C: {
                    if (!this.myMetadataSource.isOnlineIndexSupported(this.getConnectionProperties())) break;
                    oracleOnlineClause = " ONLINE DEFERRED INVALIDATION";
                    break;
                }
            }
        }
        String bareCreateSql = "create " + unique + "index " + postgresOnlineClause + this.myIndexName + " on " + this.getTableName() + "(" + columns + ")" + (String)includeClause + mssqlWhereClause + oracleOnlineClause;
        Object sql = this.myOnline && DriverTypeEnum.MSSQL_2012 == this.getDriverType() ? AddIndexTask.buildOnlineCreateWithTryCatchFallback(bareCreateSql) : bareCreateSql;
        return sql;
    }

    @Nonnull
    static String buildOnlineCreateWithTryCatchFallback(String bareCreateSql) {
        return "BEGIN TRY -- try first online, without locking the table \n    EXEC('" + bareCreateSql + " WITH (ONLINE = ON)');\nEND TRY \nBEGIN CATCH -- for Editions of Sql Server that don't support ONLINE, run with table locks \n" + bareCreateSql + "; \nEND CATCH;";
    }

    @Nonnull
    private String buildMSSqlNotNullWhereClause() {
        Object mssqlWhereClause = "";
        if (this.myNullableColumns == null || this.myNullableColumns.isEmpty()) {
            return mssqlWhereClause;
        }
        mssqlWhereClause = " WHERE (";
        mssqlWhereClause = (String)mssqlWhereClause + this.myNullableColumns.stream().map(column -> column + " IS NOT NULL ").collect(Collectors.joining("AND"));
        mssqlWhereClause = (String)mssqlWhereClause + ")";
        return mssqlWhereClause;
    }

    public void setColumns(String ... theColumns) {
        this.setColumns(Arrays.asList(theColumns));
    }

    public void setNullableColumns(String ... theColumns) {
        this.setNullableColumns(Arrays.asList(theColumns));
    }

    public void setIncludeColumns(String ... theIncludeColumns) {
        this.setIncludeColumns(Arrays.asList(theIncludeColumns));
    }

    private void setIncludeColumns(List<String> theIncludeColumns) {
        Objects.requireNonNull(theIncludeColumns);
        this.myIncludeColumns = theIncludeColumns;
    }

    public void setOnline(boolean theFlag) {
        this.myOnline = theFlag;
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        super.generateEquals(theBuilder, theOtherObject);
        AddIndexTask otherObject = (AddIndexTask)theOtherObject;
        theBuilder.append((Object)this.myIndexName, (Object)otherObject.myIndexName);
        theBuilder.append(this.myColumns, otherObject.myColumns);
        theBuilder.append((Object)this.myUnique, (Object)otherObject.myUnique);
        theBuilder.append(this.myIncludeColumns, otherObject.myIncludeColumns);
        theBuilder.append(this.myOnline, otherObject.myOnline);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myIndexName);
        theBuilder.append(this.myColumns);
        theBuilder.append((Object)this.myUnique);
        theBuilder.append(this.myOnline);
    }

    public void setMetadataSource(MetadataSource theMetadataSource) {
        this.myMetadataSource = theMetadataSource;
    }
}

