/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnDriverMappingOverride;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeToDriverTypeToSqlType;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableTask
extends BaseTask {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseTableTask.class);
    private String myTableName;
    private final List<ColumnDriverMappingOverride> myColumnDriverMappingOverrides;

    public BaseTableTask(String theProductVersion, String theSchemaVersion) {
        this(theProductVersion, theSchemaVersion, Collections.emptySet());
    }

    public BaseTableTask(String theProductVersion, String theSchemaVersion, Set<ColumnDriverMappingOverride> theColumnDriverMappingOverrides) {
        super(theProductVersion, theSchemaVersion);
        this.myColumnDriverMappingOverrides = new ArrayList<ColumnDriverMappingOverride>(theColumnDriverMappingOverrides);
    }

    public String getTableName() {
        return this.myTableName;
    }

    public BaseTableTask setTableName(String theTableName) {
        Validate.notBlank((CharSequence)theTableName);
        this.myTableName = theTableName;
        return this;
    }

    @Override
    public void validate() {
        Validate.notBlank((CharSequence)this.myTableName);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        BaseTableTask otherObject = (BaseTableTask)theOtherObject;
        theBuilder.append((Object)this.myTableName, (Object)otherObject.myTableName);
    }

    protected String getSqlType(ColumnTypeEnum theColumnType, Long theColumnLength) {
        String retVal = this.getColumnSqlWithToken(theColumnType);
        Objects.requireNonNull(retVal);
        if (theColumnType == ColumnTypeEnum.STRING) {
            return retVal.replace("?", Long.toString(theColumnLength));
        }
        return retVal;
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        theBuilder.append((Object)this.myTableName);
    }

    @Nonnull
    private String getColumnSqlWithToken(ColumnTypeEnum theColumnType) {
        List eligibleOverrides = this.myColumnDriverMappingOverrides.stream().filter(override -> override.getColumnType() == theColumnType).filter(override -> override.getDriverType() == this.getDriverType()).collect(Collectors.toUnmodifiableList());
        if (eligibleOverrides.size() > 1) {
            ourLog.info("There is more than one eligible override: {}.  Picking the first one", eligibleOverrides);
        }
        if (eligibleOverrides.size() == 1) {
            return ((ColumnDriverMappingOverride)eligibleOverrides.get(0)).getColumnTypeSql();
        }
        if (!ColumnTypeToDriverTypeToSqlType.getColumnTypeToDriverTypeToSqlType().containsKey((Object)theColumnType)) {
            throw new IllegalArgumentException(Msg.code((int)2449) + "Column type does not exist: " + String.valueOf((Object)theColumnType));
        }
        return ColumnTypeToDriverTypeToSqlType.getColumnTypeToDriverTypeToSqlType().get((Object)theColumnType).get((Object)this.getDriverType());
    }
}

