/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteRawSqlTask
extends BaseTask {
    private static final Logger ourLog = LoggerFactory.getLogger(ExecuteRawSqlTask.class);
    private Map<DriverTypeEnum, List<String>> myDriverToSqls = new HashMap<DriverTypeEnum, List<String>>();
    private List<String> myDriverNeutralSqls = new ArrayList<String>();

    public ExecuteRawSqlTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
        this.setDescription("Execute raw sql");
    }

    public ExecuteRawSqlTask addSql(DriverTypeEnum theDriverType, @Language(value="SQL") String theSql) {
        Validate.notNull((Object)((Object)theDriverType));
        Validate.notBlank((CharSequence)theSql);
        List list = this.myDriverToSqls.computeIfAbsent(theDriverType, t -> new ArrayList());
        String sql = StringUtils.trim((String)theSql);
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        list.add(sql);
        return this;
    }

    public ExecuteRawSqlTask addSql(String theSql) {
        Validate.notBlank((CharSequence)"theSql must not be null", (String)theSql, (Object[])new Object[0]);
        this.myDriverNeutralSqls.add(theSql);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void doExecute() {
        List sqlStatements = this.myDriverToSqls.computeIfAbsent(this.getDriverType(), t -> new ArrayList());
        sqlStatements.addAll(this.myDriverNeutralSqls);
        this.logInfo(ourLog, "Going to execute {} SQL statements", sqlStatements.size());
        for (String nextSql : sqlStatements) {
            this.executeSql(null, nextSql, new Object[0]);
        }
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        ExecuteRawSqlTask otherObject = (ExecuteRawSqlTask)theOtherObject;
        theBuilder.append(this.myDriverNeutralSqls, otherObject.myDriverNeutralSqls);
        theBuilder.append(this.myDriverToSqls, otherObject.myDriverToSqls);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        theBuilder.append(this.myDriverNeutralSqls);
        theBuilder.append(this.myDriverToSqls);
    }
}

