/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.tasks.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.MigrationTaskList;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.tasks.api.Builder;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.Validate;
import org.flywaydb.core.api.MigrationVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMigrationTasks<T extends Enum> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseMigrationTasks.class);
    private Multimap<T, BaseTask> myTasks = MultimapBuilder.hashKeys().arrayListValues().build();

    public MigrationTaskList getTaskList(@Nonnull T theFrom, @Nonnull T theTo) {
        Validate.notNull(theFrom);
        Validate.notNull(theTo);
        Validate.isTrue((((Enum)theFrom).ordinal() < ((Enum)theTo).ordinal() ? 1 : 0) != 0, (String)"From version must be lower than to version", (Object[])new Object[0]);
        MigrationTaskList retVal = new MigrationTaskList();
        for (Object nextVersion : EnumUtils.getEnumList(theFrom.getClass())) {
            if (((Enum)nextVersion).ordinal() <= ((Enum)theFrom).ordinal() || ((Enum)nextVersion).ordinal() > ((Enum)theTo).ordinal()) continue;
            Collection nextValues = this.myTasks.get((Object)((Enum)nextVersion));
            retVal.addAll(nextValues);
        }
        return retVal;
    }

    public Builder forVersion(T theRelease) {
        IAcceptsTasks sink = theTask -> {
            theTask.validate();
            this.myTasks.put((Object)theRelease, (Object)theTask);
        };
        return new Builder(this.toReleaseName(theRelease), sink);
    }

    @Nonnull
    protected String toReleaseName(T theRelease) {
        return ((Enum)theRelease).name();
    }

    public MigrationTaskList getAllTasks(T ... theVersionEnumValues) {
        MigrationTaskList retval = new MigrationTaskList();
        T[] TArray = theVersionEnumValues;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T nextVersion;
            Collection nextValues = this.myTasks.get(nextVersion = TArray[i]);
            ourLog.debug("Version {} has {} migration tasks", nextVersion, nextValues != null ? Integer.valueOf(nextValues.size()) : "(no)");
            if (nextValues == null || nextValues.isEmpty()) continue;
            this.validate(nextValues);
            retval.addAll(nextValues);
        }
        return retval;
    }

    public boolean hasTasksForVersion(T theRelease) {
        Collection baseTasks = this.myTasks.get(theRelease);
        return Objects.nonNull(baseTasks) && !baseTasks.isEmpty();
    }

    protected BaseTask getTaskWithVersion(String theMigrationVersion) {
        String expectedVersion = MigrationVersion.fromVersion((String)theMigrationVersion).getVersion();
        return this.myTasks.values().stream().filter(task -> expectedVersion.equals(task.getMigrationVersion())).findFirst().get();
    }

    void validate(Collection<BaseTask> theTasks) {
        MigrationVersion lastVersion = null;
        for (BaseTask task : theTasks) {
            task.validateVersion();
            String version = task.getMigrationVersion();
            MigrationVersion migrationVersion = MigrationVersion.fromVersion((String)version);
            if (lastVersion != null && migrationVersion.compareTo(lastVersion) <= 0) {
                throw new IllegalStateException(Msg.code((int)51) + "Migration version " + String.valueOf(migrationVersion) + " found after migration version " + String.valueOf(lastVersion) + ".  Migrations need to be in order by version number.");
            }
            lastVersion = migrationVersion;
        }
    }

    public static interface IAcceptsTasks {
        public void addTask(BaseTask var1);
    }
}

