/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.model.BulkExportJobResults;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.bulk.export.model.BulkExportResponseJson;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.PreferHeader;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.ArrayUtil;
import ca.uhn.fhir.util.DatatypeUtil;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.SearchParameterUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkDataExportProvider {
    public static final String FARM_TO_TABLE_TYPE_FILTER_REGEX = "(?:,)(?=[A-Z][a-z]+\\?)";
    public static final List<String> PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES = List.of("Practitioner", "Organization");
    public static final String UNSUPPORTED_BINARY_TYPE = "Binary";
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataExportProvider.class);
    private static final Set<FhirVersionEnum> PATIENT_COMPARTMENT_FHIR_VERSIONS_SUPPORT_DEVICE = Set.of(FhirVersionEnum.DSTU2, FhirVersionEnum.DSTU2_1, FhirVersionEnum.DSTU2_HL7ORG, FhirVersionEnum.DSTU3, FhirVersionEnum.R4, FhirVersionEnum.R4B);
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    private Set<String> myCompartmentResources;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IJobCoordinator myJobCoordinator;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;

    @Operation(name="$export", global=false, manualResponse=true, idempotent=true, canonicalUrl="http://hl7.org/fhir/uv/bulkdata/OperationDefinition/export")
    public void export(@OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, @OperationParam(name="_typePostFetchFilterUrl", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypePostFetchFilterUrl, @OperationParam(name="_exportId", min=0, max=1, typeName="string") IPrimitiveType<String> theExportId, ServletRequestDetails theRequestDetails) {
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        BulkExportJobParameters BulkExportJobParameters2 = this.buildSystemBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter, theExportId, theTypePostFetchFilterUrl);
        this.startJob(theRequestDetails, BulkExportJobParameters2);
    }

    private void startJob(ServletRequestDetails theRequestDetails, BulkExportJobParameters theOptions) {
        this.expandParameters(theRequestDetails, theOptions);
        HookParams initiateBulkExportHookParams = new HookParams().add(BulkExportJobParameters.class, (Object)theOptions).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_INITIATE_BULK_EXPORT, (HookParams)initiateBulkExportHookParams);
        boolean useCache = this.shouldUseCache(theRequestDetails);
        JobInstanceStartRequest startRequest = new JobInstanceStartRequest();
        startRequest.setParameters((IModelJson)theOptions);
        startRequest.setUseCache(useCache);
        startRequest.setJobDefinitionId("BULK_EXPORT");
        Batch2JobStartResponse response = this.myJobCoordinator.startInstance((RequestDetails)theRequestDetails, startRequest);
        this.writePollingLocationToResponseHeaders(theRequestDetails, response.getInstanceId());
    }

    private void expandParameters(ServletRequestDetails theRequestDetails, BulkExportJobParameters theOptions) {
        theOptions.setOriginalRequestUrl(theRequestDetails.getCompleteUrl());
        if (theOptions.getResourceTypes().isEmpty()) {
            ArrayList resourceTypes = new ArrayList(this.myDaoRegistry.getRegisteredDaoTypes());
            resourceTypes.remove(UNSUPPORTED_BINARY_TYPE);
            theOptions.setResourceTypes(resourceTypes);
        }
        RequestPartitionId partitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForServerOperation((RequestDetails)theRequestDetails, "$export");
        this.myRequestPartitionHelperService.validateHasPartitionPermissions((RequestDetails)theRequestDetails, UNSUPPORTED_BINARY_TYPE, partitionId);
        theOptions.setPartitionId(partitionId);
        HookParams preInitiateBulkExportHookParams = new HookParams();
        preInitiateBulkExportHookParams.add(BulkExportJobParameters.class, (Object)theOptions);
        preInitiateBulkExportHookParams.add(RequestDetails.class, (Object)theRequestDetails);
        preInitiateBulkExportHookParams.addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PRE_INITIATE_BULK_EXPORT, (HookParams)preInitiateBulkExportHookParams);
    }

    private boolean shouldUseCache(ServletRequestDetails theRequestDetails) {
        CacheControlDirective cacheControlDirective = new CacheControlDirective().parse(theRequestDetails.getHeaders("Cache-Control"));
        return this.myStorageSettings.getEnableBulkExportJobReuse() && !cacheControlDirective.isNoCache();
    }

    private String getServerBase(ServletRequestDetails theRequestDetails) {
        return StringUtils.removeEnd((String)theRequestDetails.getServerBaseForRequest(), (String)"/");
    }

    @Operation(name="$export", manualResponse=true, idempotent=true, typeName="Group", canonicalUrl="http://hl7.org/fhir/uv/bulkdata/OperationDefinition/group-export")
    public void groupExport(@IdParam IIdType theIdParam, @OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, @OperationParam(name="_typePostFetchFilterUrl", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypePostFetchFilterUrl, @OperationParam(name="_mdm", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theMdm, @OperationParam(name="_exportId", min=0, max=1, typeName="string") IPrimitiveType<String> theExportIdentifier, ServletRequestDetails theRequestDetails) {
        ourLog.debug("Received Group Bulk Export Request for Group {}", (Object)theIdParam);
        ourLog.debug("_type={}", theType);
        ourLog.debug("_since={}", theSince);
        ourLog.debug("_typeFilter={}", theTypeFilter);
        ourLog.debug("_mdm={}", theMdm);
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        this.validateTargetsExists((RequestDetails)theRequestDetails, "Group", List.of(theIdParam));
        BulkExportJobParameters BulkExportJobParameters2 = this.buildGroupBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter, theIdParam, theMdm, theExportIdentifier, theTypePostFetchFilterUrl);
        if (CollectionUtils.isNotEmpty((Collection)BulkExportJobParameters2.getResourceTypes())) {
            this.validateResourceTypesAllContainPatientSearchParams(BulkExportJobParameters2.getResourceTypes());
        } else {
            HashSet<String> groupTypes = new HashSet<String>(this.getPatientCompartmentResources());
            groupTypes.addAll(PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES);
            groupTypes.removeIf(t -> !this.myDaoRegistry.isResourceTypeSupported(t));
            BulkExportJobParameters2.setResourceTypes(groupTypes);
        }
        this.startJob(theRequestDetails, BulkExportJobParameters2);
    }

    private void validateTargetsExists(RequestDetails theRequestDetails, String theTargetResourceName, Iterable<IIdType> theIdParams) {
        if (theIdParams.iterator().hasNext()) {
            RequestPartitionId partitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForRead(theRequestDetails, theTargetResourceName, theIdParams.iterator().next());
            SystemRequestDetails requestDetails = new SystemRequestDetails().setRequestPartitionId(partitionId);
            for (IIdType nextId : theIdParams) {
                this.myDaoRegistry.getResourceDao(theTargetResourceName).read(nextId, (RequestDetails)requestDetails);
            }
        }
    }

    private void validateResourceTypesAllContainPatientSearchParams(Collection<String> theResourceTypes) {
        List badResourceTypes;
        if (theResourceTypes != null && !(badResourceTypes = theResourceTypes.stream().filter(resourceType -> !PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(resourceType)).filter(resourceType -> !this.getPatientCompartmentResources().contains(resourceType)).collect(Collectors.toList())).isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)512) + String.format("Resource types [%s] are invalid for this type of export, as they do not contain search parameters that refer to patients.", String.join((CharSequence)",", badResourceTypes)));
        }
    }

    private Set<String> getPatientCompartmentResources() {
        return this.getPatientCompartmentResources(this.myFhirContext);
    }

    @VisibleForTesting
    Set<String> getPatientCompartmentResources(FhirContext theFhirContext) {
        if (this.myCompartmentResources == null) {
            this.myCompartmentResources = new HashSet<String>(SearchParameterUtil.getAllResourceTypesThatAreInPatientCompartment((FhirContext)theFhirContext));
            if (BulkDataExportProvider.isDeviceResourceSupportedForPatientCompartmentForFhirVersion(theFhirContext.getVersion().getVersion())) {
                this.myCompartmentResources.add("Device");
            }
        }
        return this.myCompartmentResources;
    }

    @Operation(name="$export", manualResponse=true, idempotent=true, typeName="Patient", canonicalUrl="http://hl7.org/fhir/uv/bulkdata/OperationDefinition/patient-export")
    public void patientExport(@OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, @OperationParam(name="_typePostFetchFilterUrl", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypePostFetchFilterUrl, @OperationParam(name="patient", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> thePatient, @OperationParam(name="_exportId", min=0, max=1, typeName="string") IPrimitiveType<String> theExportIdentifier, ServletRequestDetails theRequestDetails) {
        ArrayList<IPrimitiveType<String>> patientIds = thePatient != null ? thePatient : new ArrayList<IPrimitiveType<String>>();
        this.doPatientExport(theRequestDetails, theOutputFormat, theType, theSince, theExportIdentifier, theTypeFilter, theTypePostFetchFilterUrl, patientIds);
    }

    @Operation(name="$export", manualResponse=true, idempotent=true, typeName="Patient")
    public void patientInstanceExport(@IdParam IIdType theIdParam, @OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, @OperationParam(name="_typePostFetchFilterUrl", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypePostFetchFilterUrl, @OperationParam(name="_exportId", min=0, max=1, typeName="string") IPrimitiveType<String> theExportIdentifier, ServletRequestDetails theRequestDetails) {
        this.patientExport(theOutputFormat, theType, theSince, theTypeFilter, theTypePostFetchFilterUrl, List.of(theIdParam), theExportIdentifier, theRequestDetails);
    }

    private void doPatientExport(ServletRequestDetails theRequestDetails, IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, IPrimitiveType<String> theExportIdentifier, List<IPrimitiveType<String>> theTypeFilter, List<IPrimitiveType<String>> theTypePostFetchFilterUrl, List<IPrimitiveType<String>> thePatientIds) {
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        this.validateTargetsExists((RequestDetails)theRequestDetails, "Patient", thePatientIds.stream().map(c -> new IdType((String)c.getValue())).collect(Collectors.toList()));
        BulkExportJobParameters BulkExportJobParameters2 = this.buildPatientBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter, theExportIdentifier, thePatientIds, theTypePostFetchFilterUrl);
        this.validateResourceTypesAllContainPatientSearchParams(BulkExportJobParameters2.getResourceTypes());
        this.startJob(theRequestDetails, BulkExportJobParameters2);
    }

    @Operation(name="$export-poll-status", manualResponse=true, idempotent=true, deleteEnabled=true)
    public void exportPollStatus(@OperationParam(name="_jobId", typeName="string", min=0, max=1) IPrimitiveType<String> theJobId, ServletRequestDetails theRequestDetails) throws IOException {
        JobInstance info;
        BulkExportJobParameters parameters;
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        if (theJobId == null) {
            Parameters parameters2 = (Parameters)theRequestDetails.getResource();
            Parameters.ParametersParameterComponent parameter = parameters2.getParameter().stream().filter(param -> param.getName().equals("_jobId")).findFirst().orElseThrow(() -> new InvalidRequestException(Msg.code((int)2227) + "$export-poll-status requires a job ID, please provide the value of target jobId."));
            theJobId = (IPrimitiveType)parameter.getValue();
        }
        if ((parameters = (BulkExportJobParameters)(info = this.myJobCoordinator.getInstance(theJobId.getValueAsString())).getParameters(BulkExportJobParameters.class)).getPartitionId() != null) {
            RequestPartitionId partitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForServerOperation((RequestDetails)theRequestDetails, "$export-poll-status");
            this.myRequestPartitionHelperService.validateHasPartitionPermissions((RequestDetails)theRequestDetails, UNSUPPORTED_BINARY_TYPE, partitionId);
            if (!parameters.getPartitionId().equals((Object)partitionId)) {
                throw new InvalidRequestException(Msg.code((int)2304) + "Invalid partition in request for Job ID " + theJobId);
            }
        }
        switch (info.getStatus()) {
            case COMPLETED: {
                if (theRequestDetails.getRequestType() == RequestTypeEnum.DELETE) {
                    this.handleDeleteRequest((IPrimitiveType<String>)theJobId, response, info.getStatus());
                    break;
                }
                response.setStatus(200);
                response.setContentType("application/json");
                BulkExportResponseJson bulkResponseDocument = new BulkExportResponseJson();
                bulkResponseDocument.setTransactionTime(info.getEndTime());
                bulkResponseDocument.setRequiresAccessToken(Boolean.valueOf(true));
                String report = info.getReport();
                if (StringUtils.isEmpty((CharSequence)report)) {
                    ourLog.error("No report for completed bulk export job.");
                    response.getWriter().close();
                    break;
                }
                BulkExportJobResults results = (BulkExportJobResults)JsonUtil.deserialize((String)report, BulkExportJobResults.class);
                bulkResponseDocument.setMsg(results.getReportMsg());
                bulkResponseDocument.setRequest(results.getOriginalRequestUrl());
                String serverBase = this.getServerBase(theRequestDetails);
                bulkResponseDocument.getOutput();
                for (Map.Entry entrySet : results.getResourceTypeToBinaryIds().entrySet()) {
                    String resourceType = (String)entrySet.getKey();
                    List binaryIds = (List)entrySet.getValue();
                    for (String binaryId : binaryIds) {
                        IdType iId = new IdType(binaryId);
                        String nextUrl = serverBase + "/" + iId.toUnqualifiedVersionless().getValue();
                        bulkResponseDocument.addOutput().setType(resourceType).setUrl(nextUrl);
                    }
                }
                JsonUtil.serialize((Object)bulkResponseDocument, (Writer)response.getWriter());
                response.getWriter().close();
                break;
            }
            case FAILED: {
                response.setStatus(500);
                response.setContentType("application/json+fhir");
                IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
                OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)oo, (String)"error", (String)info.getErrorMessage(), null, null);
                this.myFhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToWriter((IBaseResource)oo, (Writer)response.getWriter());
                response.getWriter().close();
                break;
            }
            default: {
                ourLog.warn("Unrecognized status encountered: {}. Treating as BUILDING/SUBMITTED", (Object)info.getStatus().name());
            }
            case FINALIZE: 
            case QUEUED: 
            case IN_PROGRESS: 
            case CANCELLED: 
            case ERRORED: {
                if (theRequestDetails.getRequestType() == RequestTypeEnum.DELETE) {
                    this.handleDeleteRequest((IPrimitiveType<String>)theJobId, response, info.getStatus());
                    break;
                }
                response.setStatus(202);
                String dateString = this.getTransitionTimeOfJobInfo(info);
                response.addHeader("X-Progress", "Build in progress - Status set to " + info.getStatus() + " at " + dateString);
                response.addHeader("Retry-After", "120");
            }
        }
    }

    private void handleDeleteRequest(IPrimitiveType<String> theJobId, HttpServletResponse response, StatusEnum theOrigStatus) throws IOException {
        IBaseOperationOutcome outcome = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
        JobOperationResultJson resultMessage = this.myJobCoordinator.cancelInstance(theJobId.getValueAsString());
        if (theOrigStatus.equals((Object)StatusEnum.COMPLETED)) {
            response.setStatus(404);
            OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)outcome, (String)"error", (String)("Job instance <" + theJobId.getValueAsString() + "> was already cancelled or has completed.  Nothing to do."), null, null);
        } else {
            response.setStatus(202);
            OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)outcome, (String)"information", (String)resultMessage.getMessage(), null, (String)"informational");
        }
        this.myFhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToWriter((IBaseResource)outcome, (Writer)response.getWriter());
        response.getWriter().close();
    }

    private String getTransitionTimeOfJobInfo(JobInstance theInfo) {
        if (theInfo.getEndTime() != null) {
            return new InstantType(theInfo.getEndTime()).getValueAsString();
        }
        if (theInfo.getStartTime() != null) {
            return new InstantType(theInfo.getStartTime()).getValueAsString();
        }
        return "";
    }

    private BulkExportJobParameters buildSystemBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, IPrimitiveType<String> theExportId, List<IPrimitiveType<String>> theTypePostFetchFilterUrl) {
        return this.buildBulkExportJobParameters(theOutputFormat, theType, theSince, theTypeFilter, theExportId, BulkExportJobParameters.ExportStyle.SYSTEM, theTypePostFetchFilterUrl);
    }

    private BulkExportJobParameters buildGroupBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, IIdType theGroupId, IPrimitiveType<Boolean> theExpandMdm, IPrimitiveType<String> theExportId, List<IPrimitiveType<String>> theTypePostFetchFilterUrl) {
        BulkExportJobParameters BulkExportJobParameters2 = this.buildBulkExportJobParameters(theOutputFormat, theType, theSince, theTypeFilter, theExportId, BulkExportJobParameters.ExportStyle.GROUP, theTypePostFetchFilterUrl);
        BulkExportJobParameters2.setGroupId(DatatypeUtil.toStringValue((IPrimitiveType)theGroupId));
        boolean mdm = false;
        if (theExpandMdm != null) {
            mdm = (Boolean)theExpandMdm.getValue();
        }
        BulkExportJobParameters2.setExpandMdm(mdm);
        return BulkExportJobParameters2;
    }

    private BulkExportJobParameters buildPatientBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, IPrimitiveType<String> theExportIdentifier, List<IPrimitiveType<String>> thePatientIds, List<IPrimitiveType<String>> theTypePostFetchFilterUrl) {
        StringDt type = theType;
        if (type == null) {
            type = new StringDt(String.join((CharSequence)",", this.getPatientCompartmentResources()));
        }
        BulkExportJobParameters BulkExportJobParameters2 = this.buildBulkExportJobParameters(theOutputFormat, (IPrimitiveType<String>)type, theSince, theTypeFilter, theExportIdentifier, BulkExportJobParameters.ExportStyle.PATIENT, theTypePostFetchFilterUrl);
        if (thePatientIds != null) {
            BulkExportJobParameters2.setPatientIds((Collection)thePatientIds.stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toSet()));
        }
        return BulkExportJobParameters2;
    }

    private BulkExportJobParameters buildBulkExportJobParameters(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, IPrimitiveType<String> theExportIdentifier, BulkExportJobParameters.ExportStyle theExportStyle, List<IPrimitiveType<String>> theTypePostFetchFilterUrl) {
        String outputFormat = theOutputFormat != null ? theOutputFormat.getValueAsString() : "application/fhir+ndjson";
        Set resourceTypes = null;
        if (theType != null) {
            resourceTypes = ArrayUtil.commaSeparatedListToCleanSet((String)theType.getValueAsString());
        }
        Date since = null;
        if (theSince != null) {
            since = (Date)theSince.getValue();
        }
        String exportIdentifier = null;
        if (theExportIdentifier != null) {
            exportIdentifier = theExportIdentifier.getValueAsString();
        }
        Set<String> typeFilters = this.splitTypeFilters(theTypeFilter);
        Set<String> typePostFetchFilterUrls = this.splitTypeFilters(theTypePostFetchFilterUrl);
        BulkExportJobParameters BulkExportJobParameters2 = new BulkExportJobParameters();
        BulkExportJobParameters2.setFilters(typeFilters);
        BulkExportJobParameters2.setPostFetchFilterUrls(typePostFetchFilterUrls);
        BulkExportJobParameters2.setExportStyle(theExportStyle);
        BulkExportJobParameters2.setExportIdentifier(exportIdentifier);
        BulkExportJobParameters2.setSince(since);
        BulkExportJobParameters2.setResourceTypes((Collection)resourceTypes);
        BulkExportJobParameters2.setOutputFormat(outputFormat);
        return BulkExportJobParameters2;
    }

    public void writePollingLocationToResponseHeaders(ServletRequestDetails theRequestDetails, String theInstanceId) {
        String serverBase = this.getServerBase(theRequestDetails);
        if (serverBase == null) {
            throw new InternalErrorException(Msg.code((int)2136) + "Unable to get the server base.");
        }
        Object pollLocation = serverBase + "/$export-poll-status?_jobId=" + theInstanceId;
        pollLocation = UrlUtil.sanitizeHeaderValue((String)pollLocation);
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        response.addHeader("Content-Location", (String)pollLocation);
        response.setStatus(202);
    }

    private Set<String> splitTypeFilters(List<IPrimitiveType<String>> theTypeFilter) {
        if (theTypeFilter == null) {
            return null;
        }
        HashSet<String> retVal = new HashSet<String>();
        for (IPrimitiveType<String> next : theTypeFilter) {
            String typeFilterString = next.getValueAsString();
            Arrays.stream(typeFilterString.split(FARM_TO_TABLE_TYPE_FILTER_REGEX)).filter(StringUtils::isNotBlank).forEach(retVal::add);
        }
        return retVal;
    }

    @VisibleForTesting
    public void setStorageSettings(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    @VisibleForTesting
    public void setDaoRegistry(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    public static void validatePreferAsyncHeader(ServletRequestDetails theRequestDetails, String theOperationName) {
        String preferHeader = theRequestDetails.getHeader("Prefer");
        PreferHeader prefer = RestfulServerUtils.parsePreferHeader(null, (String)preferHeader);
        if (!prefer.getRespondAsync()) {
            throw new InvalidRequestException(Msg.code((int)513) + "Must request async processing for " + theOperationName);
        }
    }

    private static boolean isDeviceResourceSupportedForPatientCompartmentForFhirVersion(FhirVersionEnum theFhirVersionEnum) {
        return PATIENT_COMPARTMENT_FHIR_VERSIONS_SUPPORT_DEVICE.contains(theFhirVersionEnum);
    }
}

