/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.IReductionStepWorker;
import ca.uhn.fhir.batch2.jobs.export.BulkExportCreateReportStep;
import ca.uhn.fhir.batch2.jobs.export.BulkExportJobParametersValidator;
import ca.uhn.fhir.batch2.jobs.export.ExpandResourceAndWriteBinaryStep;
import ca.uhn.fhir.batch2.jobs.export.ExpandResourcesStep;
import ca.uhn.fhir.batch2.jobs.export.FetchResourceIdsStep;
import ca.uhn.fhir.batch2.jobs.export.WriteBinaryStep;
import ca.uhn.fhir.batch2.jobs.export.models.BulkExportBinaryFileId;
import ca.uhn.fhir.batch2.jobs.export.models.ExpandedResourcesList;
import ca.uhn.fhir.batch2.jobs.export.models.ResourceIdList;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.jpa.api.model.BulkExportJobResults;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class BulkExportAppCtx {
    public static final String WRITE_TO_BINARIES = "write-to-binaries";
    public static final String CREATE_REPORT_STEP = "create-report-step";

    @Bean
    public JobDefinition bulkExportJobDefinition() {
        JobDefinition.Builder builder = JobDefinition.newBuilder();
        builder.setJobDefinitionId("BULK_EXPORT");
        builder.setJobDescription("FHIR Bulk Export");
        builder.setJobDefinitionVersion(1);
        JobDefinition def = builder.setParametersType(BulkExportJobParameters.class).setParametersValidator((IJobParametersValidator)this.bulkExportJobParametersValidator()).gatedExecution().addFirstStep("fetch-resources", "Fetches resource PIDs for exporting", ResourceIdList.class, (IJobStepWorker)this.fetchResourceIdsStep()).addIntermediateStep("expand-resources", "Expand out resources", ExpandedResourcesList.class, (IJobStepWorker)this.expandResourcesStep()).addIntermediateStep(WRITE_TO_BINARIES, "Writes the expanded resources to the binaries and saves", BulkExportBinaryFileId.class, (IJobStepWorker)this.writeBinaryStep()).addFinalReducerStep(CREATE_REPORT_STEP, "Creates the output report from a bulk export job", BulkExportJobResults.class, (IReductionStepWorker)this.createReportStep()).build();
        return def;
    }

    @Bean
    public JobDefinition bulkExportJobV2Definition() {
        JobDefinition.Builder builder = JobDefinition.newBuilder();
        builder.setJobDefinitionId("BULK_EXPORT");
        builder.setJobDescription("FHIR Bulk Export");
        builder.setJobDefinitionVersion(2);
        JobDefinition def = builder.setParametersType(BulkExportJobParameters.class).setParametersValidator((IJobParametersValidator)this.bulkExportJobParametersValidator()).gatedExecution().addFirstStep("fetch-resources", "Fetches resource PIDs for exporting", ResourceIdList.class, (IJobStepWorker)this.fetchResourceIdsStep()).addIntermediateStep(WRITE_TO_BINARIES, "Writes the expanded resources to the binaries and saves", BulkExportBinaryFileId.class, (IJobStepWorker)this.expandResourceAndWriteBinaryStep()).addFinalReducerStep(CREATE_REPORT_STEP, "Creates the output report from a bulk export job", BulkExportJobResults.class, (IReductionStepWorker)this.createReportStep()).build();
        return def;
    }

    @Bean
    public BulkExportJobParametersValidator bulkExportJobParametersValidator() {
        return new BulkExportJobParametersValidator();
    }

    @Bean
    public FetchResourceIdsStep fetchResourceIdsStep() {
        return new FetchResourceIdsStep();
    }

    @Bean
    public ExpandResourcesStep expandResourcesStep() {
        return new ExpandResourcesStep();
    }

    @Bean
    public WriteBinaryStep writeBinaryStep() {
        return new WriteBinaryStep();
    }

    @Bean
    public ExpandResourceAndWriteBinaryStep expandResourceAndWriteBinaryStep() {
        return new ExpandResourceAndWriteBinaryStep();
    }

    @Bean
    @Scope(value="prototype")
    public BulkExportCreateReportStep createReportStep() {
        return new BulkExportCreateReportStep();
    }
}

