/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.ChunkExecutionDetails;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobInstance;
import ca.uhn.fhir.batch2.api.IReductionStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.jobs.export.models.BulkExportBinaryFileId;
import ca.uhn.fhir.batch2.model.ChunkOutcome;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.jpa.api.model.BulkExportJobResults;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkExportCreateReportStep
implements IReductionStepWorker<BulkExportJobParameters, BulkExportBinaryFileId, BulkExportJobResults> {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkExportCreateReportStep.class);
    private Map<String, List<String>> myResourceToBinaryIds;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<BulkExportJobParameters, BulkExportBinaryFileId> theStepExecutionDetails, @Nonnull IJobDataSink<BulkExportJobResults> theDataSink) throws JobExecutionFailedException {
        BulkExportJobResults results = new BulkExportJobResults();
        String requestUrl = BulkExportCreateReportStep.getOriginatingRequestUrl(theStepExecutionDetails, results);
        results.setOriginalRequestUrl(requestUrl);
        if (this.myResourceToBinaryIds != null) {
            ourLog.info("Bulk Export Report creation step for instance: {}", (Object)theStepExecutionDetails.getInstance().getInstanceId());
            results.setResourceTypeToBinaryIds(this.myResourceToBinaryIds);
            this.myResourceToBinaryIds = null;
        } else {
            String msg = "Export complete, but no data to generate report for job instance: " + theStepExecutionDetails.getInstance().getInstanceId();
            ourLog.warn(msg);
            results.setReportMsg(msg);
        }
        theDataSink.accept((IModelJson)results);
        return RunOutcome.SUCCESS;
    }

    @Nonnull
    public ChunkOutcome consume(ChunkExecutionDetails<BulkExportJobParameters, BulkExportBinaryFileId> theChunkDetails) {
        BulkExportBinaryFileId fileId = (BulkExportBinaryFileId)theChunkDetails.getData();
        if (this.myResourceToBinaryIds == null) {
            this.myResourceToBinaryIds = new HashMap<String, List<String>>();
        }
        this.myResourceToBinaryIds.putIfAbsent(fileId.getResourceType(), new ArrayList());
        this.myResourceToBinaryIds.get(fileId.getResourceType()).add(fileId.getBinaryId());
        return ChunkOutcome.SUCCESS();
    }

    private static String getOriginatingRequestUrl(@Nonnull StepExecutionDetails<BulkExportJobParameters, BulkExportBinaryFileId> theStepExecutionDetails, BulkExportJobResults results) {
        IJobInstance instance = theStepExecutionDetails.getInstance();
        String url = "";
        if (instance instanceof JobInstance) {
            String originalRequestUrl;
            JobInstance jobInstance = (JobInstance)instance;
            BulkExportJobParameters parameters = (BulkExportJobParameters)jobInstance.getParameters(BulkExportJobParameters.class);
            url = originalRequestUrl = parameters.getOriginalRequestUrl();
        }
        return url;
    }
}

