/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.binary.api.IBinaryStorageSvc;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkExportJobParametersValidator
implements IJobParametersValidator<BulkExportJobParameters> {
    @Deprecated(since="6.3.10")
    public static final String UNSUPPORTED_BINARY_TYPE = "Binary";
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private InMemoryResourceMatcher myInMemoryResourceMatcher;
    @Autowired(required=false)
    private IBinaryStorageSvc myBinaryStorageSvc;

    @Nullable
    public List<String> validate(RequestDetails theRequestDetails, @Nonnull BulkExportJobParameters theParameters) {
        BulkExportJobParameters.ExportStyle style;
        ArrayList<String> errorMsgs = new ArrayList<String>();
        List resourceTypes = theParameters.getResourceTypes();
        if (resourceTypes != null && !resourceTypes.isEmpty()) {
            for (String resourceType : theParameters.getResourceTypes()) {
                if (resourceType.equalsIgnoreCase(UNSUPPORTED_BINARY_TYPE)) {
                    errorMsgs.add("Bulk export of Binary resources is forbidden");
                    continue;
                }
                if (this.myDaoRegistry.isResourceTypeSupported(resourceType)) continue;
                errorMsgs.add("Resource type " + resourceType + " is not a supported resource type!");
            }
        }
        if (!"application/fhir+ndjson".equalsIgnoreCase(theParameters.getOutputFormat())) {
            errorMsgs.add("The only allowed format for Bulk Export is currently application/fhir+ndjson");
        }
        if (!StringUtils.isBlank((CharSequence)theParameters.getExportIdentifier()) && this.myBinaryStorageSvc != null && !this.myBinaryStorageSvc.isValidBinaryContentId(theParameters.getExportIdentifier())) {
            errorMsgs.add("Export ID does not conform to the current blob storage implementation's limitations.");
        }
        if ((style = theParameters.getExportStyle()) == null) {
            errorMsgs.add("Export style is required");
        } else {
            switch (style) {
                case GROUP: {
                    if (theParameters.getGroupId() != null && !theParameters.getGroupId().isEmpty()) break;
                    errorMsgs.add("Group export requires a group id, but none provided.");
                    break;
                }
            }
        }
        for (String next : theParameters.getPostFetchFilterUrls()) {
            if (!next.contains("?") || StringUtils.isBlank((CharSequence)next.substring(next.indexOf(63) + 1))) {
                errorMsgs.add("Invalid post-fetch filter URL, must be in the format [resourceType]?[parameters]: " + next);
                continue;
            }
            String resourceType = next.substring(0, next.indexOf(63));
            if (!this.myDaoRegistry.isResourceTypeSupported(resourceType)) {
                errorMsgs.add("Invalid post-fetch filter URL, unknown resource type: " + resourceType);
                continue;
            }
            try {
                InMemoryMatchResult inMemoryMatchResult = this.myInMemoryResourceMatcher.canBeEvaluatedInMemory(next);
                if (inMemoryMatchResult.supported()) continue;
                errorMsgs.add("Invalid post-fetch filter URL, filter is not supported for in-memory matching \"" + next + "\". Reason: " + inMemoryMatchResult.getUnsupportedReason());
            }
            catch (InvalidRequestException e) {
                errorMsgs.add("Invalid post-fetch filter URL. Reason: " + e.getMessage());
            }
        }
        return errorMsgs;
    }
}

