/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.jobs.export.models.BulkExportBinaryFileId;
import ca.uhn.fhir.batch2.jobs.export.models.ExpandedResourcesList;
import ca.uhn.fhir.batch2.jobs.export.models.ResourceIdList;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.executor.InterceptorService;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkExportProcessor;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.jpa.util.RandomTextUtils;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.interceptor.ResponseTerminologyTranslationSvc;
import ca.uhn.fhir.util.BinaryUtil;
import ca.uhn.fhir.util.FhirTerser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ExpandResourceAndWriteBinaryStep
implements IJobStepWorker<BulkExportJobParameters, ResourceIdList, BulkExportBinaryFileId> {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpandResourceAndWriteBinaryStep.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private InMemoryResourceMatcher myInMemoryResourceMatcher;
    @Autowired
    private IBulkExportProcessor<?> myBulkExportProcessor;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private ApplicationContext myApplicationContext;
    @Autowired
    private InterceptorService myInterceptorService;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private IHapiTransactionService myTransactionService;
    private volatile ResponseTerminologyTranslationSvc myResponseTerminologyTranslationSvc;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<BulkExportJobParameters, ResourceIdList> theStepExecutionDetails, @Nonnull IJobDataSink<BulkExportBinaryFileId> theDataSink) throws JobExecutionFailedException {
        NdJsonResourceWriter resourceWriter = new NdJsonResourceWriter(theStepExecutionDetails, theDataSink);
        this.expandResourcesFromList(theStepExecutionDetails, resourceWriter);
        return new RunOutcome(resourceWriter.getNumResourcesProcessed());
    }

    private void expandResourcesFromList(StepExecutionDetails<BulkExportJobParameters, ResourceIdList> theStepExecutionDetails, Consumer<ExpandedResourcesList> theResourceWriter) {
        ResourceIdList idList = (ResourceIdList)theStepExecutionDetails.getData();
        BulkExportJobParameters parameters = (BulkExportJobParameters)theStepExecutionDetails.getParameters();
        ExpandResourcesConsumer resourceListConsumer = new ExpandResourcesConsumer(theStepExecutionDetails, theResourceWriter);
        this.fetchResourcesByIdAndConsumeThem(idList, parameters.getPartitionId(), resourceListConsumer);
    }

    private void fetchResourcesByIdAndConsumeThem(ResourceIdList theIds, RequestPartitionId theRequestPartitionId, Consumer<List<IBaseResource>> theResourceListConsumer) {
        ArrayListMultimap typeToIds = ArrayListMultimap.create();
        theIds.getIds().forEach(t -> typeToIds.put((Object)t.getResourceType(), (Object)t.getId()));
        for (String resourceType : typeToIds.keySet()) {
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
            List allIds = typeToIds.get((Object)resourceType);
            while (!allIds.isEmpty()) {
                int batchSize = Math.min(500, allIds.size());
                Set nextBatchOfPids = allIds.subList(0, batchSize).stream().map(t -> this.myIdHelperService.newPidFromStringIdAndResourceName(t, resourceType)).collect(Collectors.toSet());
                allIds = allIds.subList(batchSize, allIds.size());
                PersistentIdToForcedIdMap nextBatchOfResourceIds = (PersistentIdToForcedIdMap)this.myTransactionService.withRequest(null).execute(() -> this.myIdHelperService.translatePidsToForcedIds(nextBatchOfPids));
                TokenOrListParam idListParam = new TokenOrListParam();
                for (IResourcePersistentId nextPid : nextBatchOfPids) {
                    Optional resourceId = nextBatchOfResourceIds.get(nextPid);
                    idListParam.add(resourceId.orElse(nextPid.getId().toString()));
                }
                SearchParameterMap spMap = SearchParameterMap.newSynchronous().add("_id", (IQueryParameterOr)idListParam);
                IBundleProvider outcome = dao.search(spMap, (RequestDetails)new SystemRequestDetails().setRequestPartitionId(theRequestPartitionId));
                theResourceListConsumer.accept(outcome.getAllResources());
            }
        }
    }

    private void addMetadataExtensionsToBinary(@Nonnull StepExecutionDetails<BulkExportJobParameters, ResourceIdList> theStepExecutionDetails, ExpandedResourcesList expandedResources, IBaseBinary binary) {
        if (binary.getMeta() instanceof IBaseHasExtensions) {
            IBaseHasExtensions meta = (IBaseHasExtensions)binary.getMeta();
            String exportIdentifier = ((BulkExportJobParameters)theStepExecutionDetails.getParameters()).getExportIdentifier();
            if (!StringUtils.isBlank((CharSequence)exportIdentifier)) {
                IBaseExtension exportIdentifierExtension = meta.addExtension();
                exportIdentifierExtension.setUrl("https://hapifhir.org/NamingSystem/bulk-export-identifier");
                exportIdentifierExtension.setValue((IBaseDatatype)this.myFhirContext.newPrimitiveString(exportIdentifier));
            }
            IBaseExtension jobExtension = meta.addExtension();
            jobExtension.setUrl("https://hapifhir.org/NamingSystem/bulk-export-job-id");
            jobExtension.setValue((IBaseDatatype)this.myFhirContext.newPrimitiveString(theStepExecutionDetails.getInstance().getInstanceId()));
            IBaseExtension typeExtension = meta.addExtension();
            typeExtension.setUrl("https://hapifhir.org/NamingSystem/bulk-export-binary-resource-type");
            typeExtension.setValue((IBaseDatatype)this.myFhirContext.newPrimitiveString(expandedResources.getResourceType()));
        } else {
            ourLog.warn("Could not attach metadata extensions to binary resource, as this binary metadata does not support extensions");
        }
    }

    protected OutputStreamWriter getStreamWriter(ByteArrayOutputStream theOutputStream) {
        return new OutputStreamWriter((OutputStream)theOutputStream, Constants.CHARSET_UTF8);
    }

    @VisibleForTesting
    public void setIdHelperServiceForUnitTest(IIdHelperService theIdHelperService) {
        this.myIdHelperService = theIdHelperService;
    }

    private class NdJsonResourceWriter
    implements Consumer<ExpandedResourcesList> {
        private final StepExecutionDetails<BulkExportJobParameters, ResourceIdList> myStepExecutionDetails;
        private final IJobDataSink<BulkExportBinaryFileId> myDataSink;
        private int myNumResourcesProcessed = 0;

        public NdJsonResourceWriter(StepExecutionDetails<BulkExportJobParameters, ResourceIdList> theStepExecutionDetails, IJobDataSink<BulkExportBinaryFileId> theDataSink) {
            this.myStepExecutionDetails = theStepExecutionDetails;
            this.myDataSink = theDataSink;
        }

        public int getNumResourcesProcessed() {
            return this.myNumResourcesProcessed;
        }

        @Override
        public void accept(ExpandedResourcesList theExpandedResourcesList) throws JobExecutionFailedException {
            int batchSize = theExpandedResourcesList.getStringifiedResources().size();
            ourLog.info("Writing {} resources to binary file", (Object)batchSize);
            this.myNumResourcesProcessed += batchSize;
            IFhirResourceDao binaryDao = ExpandResourceAndWriteBinaryStep.this.myDaoRegistry.getResourceDao("Binary");
            IBaseBinary binary = BinaryUtil.newBinary((FhirContext)ExpandResourceAndWriteBinaryStep.this.myFhirContext);
            ExpandResourceAndWriteBinaryStep.this.addMetadataExtensionsToBinary(this.myStepExecutionDetails, theExpandedResourcesList, binary);
            binary.setContentType("application/fhir+ndjson");
            int processedRecordsCount = 0;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                try (OutputStreamWriter streamWriter = ExpandResourceAndWriteBinaryStep.this.getStreamWriter(outputStream);){
                    for (String stringified : theExpandedResourcesList.getStringifiedResources()) {
                        streamWriter.append(stringified);
                        streamWriter.append("\n");
                        ++processedRecordsCount;
                    }
                    streamWriter.flush();
                    outputStream.flush();
                }
                binary.setContent(outputStream.toByteArray());
            }
            catch (IOException ex) {
                String errorMsg = String.format("Failure to process resource of type %s : %s", theExpandedResourcesList.getResourceType(), ex.getMessage());
                ourLog.error(errorMsg);
                throw new JobExecutionFailedException(Msg.code((int)2431) + errorMsg);
            }
            SystemRequestDetails srd = new SystemRequestDetails();
            BulkExportJobParameters jobParameters = (BulkExportJobParameters)this.myStepExecutionDetails.getParameters();
            RequestPartitionId partitionId = jobParameters.getPartitionId();
            if (partitionId == null) {
                srd.setRequestPartitionId(RequestPartitionId.defaultPartition());
            } else {
                srd.setRequestPartitionId(partitionId);
            }
            while (true) {
                String proposedId = RandomTextUtils.newSecureRandomAlphaNumericString((int)32);
                binary.setId(proposedId);
                try {
                    IBaseBinary output = (IBaseBinary)binaryDao.read(binary.getIdElement(), (RequestDetails)new SystemRequestDetails(), true);
                    if (output == null) break;
                }
                catch (ResourceNotFoundException output) {
                    // empty catch block
                    break;
                }
            }
            if (ExpandResourceAndWriteBinaryStep.this.myFhirContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2) && (StringUtils.isNotBlank((CharSequence)jobParameters.getBinarySecurityContextIdentifierSystem()) || StringUtils.isNotBlank((CharSequence)jobParameters.getBinarySecurityContextIdentifierValue()))) {
                FhirTerser terser = ExpandResourceAndWriteBinaryStep.this.myFhirContext.newTerser();
                terser.setElement((IBase)binary, "securityContext.identifier.system", jobParameters.getBinarySecurityContextIdentifierSystem());
                terser.setElement((IBase)binary, "securityContext.identifier.value", jobParameters.getBinarySecurityContextIdentifierValue());
            }
            DaoMethodOutcome outcome = binaryDao.update((IBaseResource)binary, (RequestDetails)srd);
            IIdType id = outcome.getId();
            BulkExportBinaryFileId bulkExportBinaryFileId = new BulkExportBinaryFileId();
            bulkExportBinaryFileId.setBinaryId(id.getValueAsString());
            bulkExportBinaryFileId.setResourceType(theExpandedResourcesList.getResourceType());
            this.myDataSink.accept((IModelJson)bulkExportBinaryFileId);
            ourLog.info("Binary writing complete for {} resources of type {}.", (Object)processedRecordsCount, (Object)theExpandedResourcesList.getResourceType());
        }
    }

    private class ExpandResourcesConsumer
    implements Consumer<List<IBaseResource>> {
        private final Consumer<ExpandedResourcesList> myResourceWriter;
        private final StepExecutionDetails<BulkExportJobParameters, ResourceIdList> myStepExecutionDetails;

        public ExpandResourcesConsumer(StepExecutionDetails<BulkExportJobParameters, ResourceIdList> theStepExecutionDetails, Consumer<ExpandedResourcesList> theResourceWriter) {
            this.myStepExecutionDetails = theStepExecutionDetails;
            this.myResourceWriter = theResourceWriter;
        }

        @Override
        public void accept(List<IBaseResource> theResources) throws JobExecutionFailedException {
            String instanceId = this.myStepExecutionDetails.getInstance().getInstanceId();
            String chunkId = this.myStepExecutionDetails.getChunkId();
            ResourceIdList idList = (ResourceIdList)this.myStepExecutionDetails.getData();
            BulkExportJobParameters parameters = (BulkExportJobParameters)this.myStepExecutionDetails.getParameters();
            ourLog.info("Bulk export instance[{}] chunk[{}] - About to expand {} resource IDs into their full resource bodies.", new Object[]{instanceId, chunkId, idList.getIds().size()});
            String resourceType = idList.getResourceType();
            List<String> postFetchFilterUrls = parameters.getPostFetchFilterUrls().stream().filter(t -> t.substring(0, t.indexOf(63)).equals(resourceType)).collect(Collectors.toList());
            if (!postFetchFilterUrls.isEmpty()) {
                this.applyPostFetchFiltering(theResources, postFetchFilterUrls, instanceId, chunkId);
            }
            if (parameters.isExpandMdm()) {
                ExpandResourceAndWriteBinaryStep.this.myBulkExportProcessor.expandMdmResources(theResources);
            }
            if (ExpandResourceAndWriteBinaryStep.this.myStorageSettings.isNormalizeTerminologyForBulkExportJobs()) {
                ResponseTerminologyTranslationSvc terminologyTranslationSvc = ExpandResourceAndWriteBinaryStep.this.myResponseTerminologyTranslationSvc;
                if (terminologyTranslationSvc == null) {
                    ExpandResourceAndWriteBinaryStep.this.myResponseTerminologyTranslationSvc = terminologyTranslationSvc = (ResponseTerminologyTranslationSvc)ExpandResourceAndWriteBinaryStep.this.myApplicationContext.getBean(ResponseTerminologyTranslationSvc.class);
                }
                terminologyTranslationSvc.processResourcesForTerminologyTranslation(theResources);
            }
            if (ExpandResourceAndWriteBinaryStep.this.myInterceptorService.hasHooks((Enum)Pointcut.STORAGE_BULK_EXPORT_RESOURCE_INCLUSION)) {
                Iterator<IBaseResource> iter = theResources.iterator();
                while (iter.hasNext()) {
                    HookParams params = new HookParams().add(BulkExportJobParameters.class, (Object)((BulkExportJobParameters)this.myStepExecutionDetails.getParameters())).add(IBaseResource.class, (Object)iter.next());
                    boolean outcome = ExpandResourceAndWriteBinaryStep.this.myInterceptorService.callHooks((Enum)Pointcut.STORAGE_BULK_EXPORT_RESOURCE_INCLUSION, params);
                    if (outcome) continue;
                    iter.remove();
                }
            }
            IParser parser = this.getParser(parameters);
            ArrayListMultimap resourceTypeToStringifiedResources = ArrayListMultimap.create();
            HashMap<String, Integer> resourceTypeToTotalSize = new HashMap<String, Integer>();
            for (IBaseResource resource : theResources) {
                long bulkExportFileMaximumSize;
                String jsonResource;
                String type = ExpandResourceAndWriteBinaryStep.this.myFhirContext.getResourceType(resource);
                int existingSize = resourceTypeToTotalSize.getOrDefault(type, 0);
                int newSize = existingSize + (jsonResource = parser.encodeResourceToString(resource)).length();
                if ((long)newSize > (bulkExportFileMaximumSize = ExpandResourceAndWriteBinaryStep.this.myStorageSettings.getBulkExportFileMaximumSize())) {
                    if (existingSize == 0) {
                        ourLog.warn("Single resource size {} exceeds allowable maximum of {}, so will ignore maximum", (Object)newSize, (Object)bulkExportFileMaximumSize);
                    } else {
                        List stringifiedResources = resourceTypeToStringifiedResources.get((Object)type);
                        this.writeStringifiedResources(type, stringifiedResources);
                        resourceTypeToStringifiedResources.removeAll((Object)type);
                        newSize = jsonResource.length();
                    }
                }
                resourceTypeToStringifiedResources.put((Object)type, (Object)jsonResource);
                resourceTypeToTotalSize.put(type, newSize);
            }
            for (String nextResourceType : resourceTypeToStringifiedResources.keySet()) {
                List stringifiedResources = resourceTypeToStringifiedResources.get((Object)nextResourceType);
                this.writeStringifiedResources(nextResourceType, stringifiedResources);
            }
        }

        private void writeStringifiedResources(String theResourceType, List<String> theStringifiedResources) {
            if (!theStringifiedResources.isEmpty()) {
                ExpandedResourcesList output = new ExpandedResourcesList();
                output.setStringifiedResources(theStringifiedResources);
                output.setResourceType(theResourceType);
                this.myResourceWriter.accept(output);
                ourLog.info("Expanding of {} resources of type {} completed", (Object)theStringifiedResources.size(), (Object)theResourceType);
            }
        }

        private void applyPostFetchFiltering(List<IBaseResource> theResources, List<String> thePostFetchFilterUrls, String theInstanceId, String theChunkId) {
            int numRemoved = 0;
            Iterator<IBaseResource> iter = theResources.iterator();
            while (iter.hasNext()) {
                boolean matched = this.applyPostFetchFilteringForSingleResource(thePostFetchFilterUrls, iter);
                if (matched) continue;
                iter.remove();
                ++numRemoved;
            }
            if (numRemoved > 0) {
                ourLog.info("Bulk export instance[{}] chunk[{}] - {} resources were filtered out because of post-fetch filter URLs", new Object[]{theInstanceId, theChunkId, numRemoved});
            }
        }

        private boolean applyPostFetchFilteringForSingleResource(List<String> thePostFetchFilterUrls, Iterator<IBaseResource> iter) {
            IBaseResource nextResource = iter.next();
            String nextResourceType = ExpandResourceAndWriteBinaryStep.this.myFhirContext.getResourceType(nextResource);
            for (String nextPostFetchFilterUrl : thePostFetchFilterUrls) {
                InMemoryMatchResult matchResult;
                String resourceType;
                if (!nextPostFetchFilterUrl.contains("?") || !nextResourceType.equals(resourceType = nextPostFetchFilterUrl.substring(0, nextPostFetchFilterUrl.indexOf(63))) || !(matchResult = ExpandResourceAndWriteBinaryStep.this.myInMemoryResourceMatcher.match(nextPostFetchFilterUrl, nextResource, null, (RequestDetails)new SystemRequestDetails())).matched()) continue;
                return true;
            }
            return false;
        }

        private IParser getParser(BulkExportJobParameters theParameters) {
            return ExpandResourceAndWriteBinaryStep.this.myFhirContext.newJsonParser().setPrettyPrint(false);
        }
    }
}

