/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.jobs.export.models.ExpandedResourcesList;
import ca.uhn.fhir.batch2.jobs.export.models.ResourceIdList;
import ca.uhn.fhir.batch2.jobs.models.BatchResourceId;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.executor.InterceptorService;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkExportProcessor;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.server.interceptor.ResponseTerminologyTranslationSvc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ExpandResourcesStep
implements IJobStepWorker<BulkExportJobParameters, ResourceIdList, ExpandedResourcesList> {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpandResourcesStep.class);
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IBulkExportProcessor<?> myBulkExportProcessor;
    @Autowired
    private ApplicationContext myApplicationContext;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private IHapiTransactionService myTransactionService;
    @Autowired
    private InMemoryResourceMatcher myInMemoryResourceMatcher;
    @Autowired
    private InterceptorService myInterceptorService;
    private volatile ResponseTerminologyTranslationSvc myResponseTerminologyTranslationSvc;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<BulkExportJobParameters, ResourceIdList> theStepExecutionDetails, @Nonnull IJobDataSink<ExpandedResourcesList> theDataSink) throws JobExecutionFailedException {
        String instanceId = theStepExecutionDetails.getInstance().getInstanceId();
        String chunkId = theStepExecutionDetails.getChunkId();
        ResourceIdList data = (ResourceIdList)theStepExecutionDetails.getData();
        BulkExportJobParameters parameters = (BulkExportJobParameters)theStepExecutionDetails.getParameters();
        ourLog.info("Bulk export instance[{}] chunk[{}] - About to expand {} resource IDs into their full resource bodies.", new Object[]{instanceId, chunkId, data.getIds().size()});
        List idLists = ListUtils.partition(data.getIds(), (int)100);
        for (List idList : idLists) {
            List<IBaseResource> allResources = this.fetchAllResources(idList, parameters.getPartitionId());
            String resourceType = data.getResourceType();
            List<String> postFetchFilterUrls = parameters.getPostFetchFilterUrls().stream().filter(t -> t.substring(0, t.indexOf(63)).equals(resourceType)).collect(Collectors.toList());
            if (!postFetchFilterUrls.isEmpty()) {
                this.applyPostFetchFiltering(allResources, postFetchFilterUrls, instanceId, chunkId);
            }
            if (parameters.isExpandMdm()) {
                this.myBulkExportProcessor.expandMdmResources(allResources);
            }
            if (this.myStorageSettings.isNormalizeTerminologyForBulkExportJobs()) {
                ResponseTerminologyTranslationSvc terminologyTranslationSvc = this.myResponseTerminologyTranslationSvc;
                if (terminologyTranslationSvc == null) {
                    this.myResponseTerminologyTranslationSvc = terminologyTranslationSvc = (ResponseTerminologyTranslationSvc)this.myApplicationContext.getBean(ResponseTerminologyTranslationSvc.class);
                }
                terminologyTranslationSvc.processResourcesForTerminologyTranslation(allResources);
            }
            if (this.myInterceptorService.hasHooks((Enum)Pointcut.STORAGE_BULK_EXPORT_RESOURCE_INCLUSION)) {
                Iterator<IBaseResource> iter = allResources.iterator();
                while (iter.hasNext()) {
                    HookParams params = new HookParams().add(BulkExportJobParameters.class, (Object)((BulkExportJobParameters)theStepExecutionDetails.getParameters())).add(IBaseResource.class, (Object)iter.next());
                    boolean outcome = this.myInterceptorService.callHooks((Enum)Pointcut.STORAGE_BULK_EXPORT_RESOURCE_INCLUSION, params);
                    if (outcome) continue;
                    iter.remove();
                }
            }
            ListMultimap<String, String> resources = this.encodeToString(allResources, parameters);
            long maxFileSize = this.myStorageSettings.getBulkExportFileMaximumSize();
            long currentFileSize = 0L;
            for (String nextResourceType : resources.keySet()) {
                List stringifiedResources = resources.get((Object)nextResourceType);
                ArrayList<String> currentFileStringifiedResources = new ArrayList<String>();
                for (String nextStringifiedResource : stringifiedResources) {
                    if (currentFileSize + (long)nextStringifiedResource.length() > maxFileSize && !currentFileStringifiedResources.isEmpty()) {
                        ExpandedResourcesList output = new ExpandedResourcesList();
                        output.setStringifiedResources(currentFileStringifiedResources);
                        output.setResourceType(nextResourceType);
                        theDataSink.accept((IModelJson)output);
                        currentFileStringifiedResources = new ArrayList();
                        currentFileSize = 0L;
                    }
                    currentFileStringifiedResources.add(nextStringifiedResource);
                    currentFileSize += (long)nextStringifiedResource.length();
                }
                if (!currentFileStringifiedResources.isEmpty()) {
                    ExpandedResourcesList output = new ExpandedResourcesList();
                    output.setStringifiedResources(currentFileStringifiedResources);
                    output.setResourceType(nextResourceType);
                    theDataSink.accept((IModelJson)output);
                }
                ourLog.info("Expanding of {} resources of type {} completed", (Object)idList.size(), (Object)data.getResourceType());
            }
        }
        return RunOutcome.SUCCESS;
    }

    private void applyPostFetchFiltering(List<IBaseResource> theResources, List<String> thePostFetchFilterUrls, String theInstanceId, String theChunkId) {
        int numRemoved = 0;
        Iterator<IBaseResource> iter = theResources.iterator();
        while (iter.hasNext()) {
            boolean matched = this.applyPostFetchFilteringForSingleResource(thePostFetchFilterUrls, iter);
            if (matched) continue;
            iter.remove();
            ++numRemoved;
        }
        if (numRemoved > 0) {
            ourLog.info("Bulk export instance[{}] chunk[{}] - {} resources were filtered out because of post-fetch filter URLs", new Object[]{theInstanceId, theChunkId, numRemoved});
        }
    }

    private boolean applyPostFetchFilteringForSingleResource(List<String> thePostFetchFilterUrls, Iterator<IBaseResource> iter) {
        IBaseResource nextResource = iter.next();
        String nextResourceType = this.myFhirContext.getResourceType(nextResource);
        for (String nextPostFetchFilterUrl : thePostFetchFilterUrls) {
            InMemoryMatchResult matchResult;
            String resourceType;
            if (!nextPostFetchFilterUrl.contains("?") || !nextResourceType.equals(resourceType = nextPostFetchFilterUrl.substring(0, nextPostFetchFilterUrl.indexOf(63))) || !(matchResult = this.myInMemoryResourceMatcher.match(nextPostFetchFilterUrl, nextResource, null, (RequestDetails)new SystemRequestDetails())).matched()) continue;
            return true;
        }
        return false;
    }

    private List<IBaseResource> fetchAllResources(List<BatchResourceId> theIds, RequestPartitionId theRequestPartitionId) {
        ArrayListMultimap typeToIds = ArrayListMultimap.create();
        theIds.forEach(t -> typeToIds.put((Object)t.getResourceType(), (Object)t.getId()));
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>(theIds.size());
        for (String resourceType : typeToIds.keySet()) {
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
            List allIds = typeToIds.get((Object)resourceType);
            Set nextBatchOfPids = allIds.stream().map(t -> this.myIdHelperService.newPidFromStringIdAndResourceName(t, resourceType)).collect(Collectors.toSet());
            PersistentIdToForcedIdMap nextBatchOfResourceIds = (PersistentIdToForcedIdMap)this.myTransactionService.withRequest(null).execute(() -> this.myIdHelperService.translatePidsToForcedIds(nextBatchOfPids));
            TokenOrListParam idListParam = new TokenOrListParam();
            for (IResourcePersistentId nextPid : nextBatchOfPids) {
                Optional resourceId = nextBatchOfResourceIds.get(nextPid);
                idListParam.add(resourceId.orElse(nextPid.getId().toString()));
            }
            SearchParameterMap spMap = SearchParameterMap.newSynchronous().add("_id", (IQueryParameterOr)idListParam);
            IBundleProvider outcome = dao.search(spMap, (RequestDetails)new SystemRequestDetails().setRequestPartitionId(theRequestPartitionId));
            resources.addAll(outcome.getAllResources());
        }
        return resources;
    }

    private ListMultimap<String, String> encodeToString(List<IBaseResource> theResources, BulkExportJobParameters theParameters) {
        IParser parser = this.getParser(theParameters);
        ArrayListMultimap retVal = ArrayListMultimap.create();
        for (IBaseResource resource : theResources) {
            String type = this.myFhirContext.getResourceType(resource);
            String jsonResource = parser.encodeResourceToString(resource);
            retVal.put((Object)type, (Object)jsonResource);
        }
        return retVal;
    }

    private IParser getParser(BulkExportJobParameters theParameters) {
        return this.myFhirContext.newJsonParser().setPrettyPrint(false);
    }

    @VisibleForTesting
    public void setIdHelperServiceForUnitTest(IIdHelperService theIdHelperService) {
        this.myIdHelperService = theIdHelperService;
    }
}

