/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.export.models.ResourceIdList;
import ca.uhn.fhir.batch2.jobs.models.BatchResourceId;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkExportProcessor;
import ca.uhn.fhir.jpa.bulk.export.model.ExportPIDIteratorParameters;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchResourceIdsStep
implements IFirstJobStepWorker<BulkExportJobParameters, ResourceIdList> {
    private static final Logger ourLog = LoggerFactory.getLogger(FetchResourceIdsStep.class);
    @Autowired
    private IBulkExportProcessor myBulkExportProcessor;
    @Autowired
    private JpaStorageSettings myStorageSettings;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<BulkExportJobParameters, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<ResourceIdList> theDataSink) throws JobExecutionFailedException {
        BulkExportJobParameters params = (BulkExportJobParameters)theStepExecutionDetails.getParameters();
        ourLog.info("Fetching resource IDs for bulk export job instance[{}]", (Object)theStepExecutionDetails.getInstance().getInstanceId());
        ExportPIDIteratorParameters providerParams = new ExportPIDIteratorParameters();
        providerParams.setInstanceId(theStepExecutionDetails.getInstance().getInstanceId());
        providerParams.setChunkId(theStepExecutionDetails.getChunkId());
        providerParams.setFilters(params.getFilters());
        providerParams.setStartDate(params.getSince());
        providerParams.setExportStyle(params.getExportStyle());
        providerParams.setGroupId(params.getGroupId());
        providerParams.setPatientIds(params.getPatientIds());
        providerParams.setExpandMdm(params.isExpandMdm());
        providerParams.setPartitionId(params.getPartitionId());
        providerParams.setRequestedResourceTypes(params.getResourceTypes());
        int submissionCount = 0;
        try {
            HashSet<BatchResourceId> submittedBatchResourceIds = new HashSet<BatchResourceId>();
            for (String resourceType : params.getResourceTypes()) {
                providerParams.setResourceType(resourceType);
                ourLog.info("Running FetchResourceIdsStep for resource type: {} with params: {}", (Object)resourceType, (Object)providerParams);
                Iterator pidIterator = this.myBulkExportProcessor.getResourcePidIterator(providerParams);
                ArrayList<BatchResourceId> idsToSubmit = new ArrayList<BatchResourceId>();
                int estimatedChunkSize = 0;
                if (!pidIterator.hasNext()) {
                    ourLog.debug("Bulk Export generated an iterator with no results!");
                }
                while (pidIterator.hasNext()) {
                    IResourcePersistentId pid = (IResourcePersistentId)pidIterator.next();
                    BatchResourceId batchResourceId = pid.getResourceType() != null ? BatchResourceId.getIdFromPID(pid, pid.getResourceType()) : BatchResourceId.getIdFromPID(pid, resourceType);
                    if (!submittedBatchResourceIds.add(batchResourceId)) continue;
                    idsToSubmit.add(batchResourceId);
                    if (estimatedChunkSize > 0) {
                        ++estimatedChunkSize;
                    }
                    if (idsToSubmit.size() < this.myStorageSettings.getBulkExportFileMaximumCapacity() && (long)(estimatedChunkSize += batchResourceId.estimateSerializedSize()) < this.myStorageSettings.getBulkExportFileMaximumSize()) continue;
                    this.submitWorkChunk(idsToSubmit, resourceType, theDataSink);
                    ++submissionCount;
                    idsToSubmit = new ArrayList();
                    estimatedChunkSize = 0;
                }
                if (idsToSubmit.isEmpty()) continue;
                this.submitWorkChunk(idsToSubmit, resourceType, theDataSink);
                ++submissionCount;
            }
        }
        catch (Exception ex) {
            ourLog.error(ex.getMessage(), (Throwable)ex);
            theDataSink.recoveredError(ex.getMessage());
            throw new JobExecutionFailedException(Msg.code((int)2239) + " : " + ex.getMessage());
        }
        ourLog.info("Submitted {} groups of ids for processing", (Object)submissionCount);
        return RunOutcome.SUCCESS;
    }

    private void submitWorkChunk(List<BatchResourceId> theBatchResourceIds, String theResourceType, IJobDataSink<ResourceIdList> theDataSink) {
        ResourceIdList idList = new ResourceIdList();
        idList.setIds(theBatchResourceIds);
        idList.setResourceType(theResourceType);
        theDataSink.accept((IModelJson)idList);
    }

    @VisibleForTesting
    public void setBulkExportProcessorForUnitTest(IBulkExportProcessor theBulkExportProcessor) {
        this.myBulkExportProcessor = theBulkExportProcessor;
    }
}

