/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.export;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.jobs.export.models.BulkExportBinaryFileId;
import ca.uhn.fhir.batch2.jobs.export.models.ExpandedResourcesList;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.util.RandomTextUtils;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.BinaryUtil;
import ca.uhn.fhir.util.FhirTerser;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WriteBinaryStep
implements IJobStepWorker<BulkExportJobParameters, ExpandedResourcesList, BulkExportBinaryFileId> {
    private static final Logger ourLog = LoggerFactory.getLogger(WriteBinaryStep.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<BulkExportJobParameters, ExpandedResourcesList> theStepExecutionDetails, @Nonnull IJobDataSink<BulkExportBinaryFileId> theDataSink) throws JobExecutionFailedException {
        ExpandedResourcesList expandedResources = (ExpandedResourcesList)theStepExecutionDetails.getData();
        int numResourcesProcessed = expandedResources.getStringifiedResources().size();
        ourLog.info("Write binary step of Job Export");
        ourLog.info("Writing {} resources to binary file", (Object)numResourcesProcessed);
        IFhirResourceDao binaryDao = this.myDaoRegistry.getResourceDao("Binary");
        IBaseBinary binary = BinaryUtil.newBinary((FhirContext)this.myFhirContext);
        this.addMetadataExtensionsToBinary(theStepExecutionDetails, expandedResources, binary);
        binary.setContentType("application/fhir+ndjson");
        int processedRecordsCount = 0;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            try (OutputStreamWriter streamWriter = this.getStreamWriter(outputStream);){
                for (String stringified : expandedResources.getStringifiedResources()) {
                    streamWriter.append(stringified);
                    streamWriter.append("\n");
                    ++processedRecordsCount;
                }
                streamWriter.flush();
                outputStream.flush();
            }
            binary.setContent(outputStream.toByteArray());
        }
        catch (IOException ex) {
            String errorMsg = String.format("Failure to process resource of type %s : %s", expandedResources.getResourceType(), ex.getMessage());
            ourLog.error(errorMsg);
            throw new JobExecutionFailedException(Msg.code((int)2238) + errorMsg);
        }
        SystemRequestDetails srd = new SystemRequestDetails();
        BulkExportJobParameters jobParameters = (BulkExportJobParameters)theStepExecutionDetails.getParameters();
        RequestPartitionId partitionId = jobParameters.getPartitionId();
        if (partitionId == null) {
            srd.setRequestPartitionId(RequestPartitionId.defaultPartition());
        } else {
            srd.setRequestPartitionId(partitionId);
        }
        while (true) {
            String proposedId = RandomTextUtils.newSecureRandomAlphaNumericString((int)32);
            binary.setId(proposedId);
            try {
                IBaseBinary output = (IBaseBinary)binaryDao.read(binary.getIdElement(), (RequestDetails)new SystemRequestDetails(), true);
                if (output == null) break;
            }
            catch (ResourceNotFoundException output) {
                // empty catch block
                break;
            }
        }
        if (this.myFhirContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2) && (StringUtils.isNotBlank((CharSequence)jobParameters.getBinarySecurityContextIdentifierSystem()) || StringUtils.isNotBlank((CharSequence)jobParameters.getBinarySecurityContextIdentifierValue()))) {
            FhirTerser terser = this.myFhirContext.newTerser();
            terser.setElement((IBase)binary, "securityContext.identifier.system", jobParameters.getBinarySecurityContextIdentifierSystem());
            terser.setElement((IBase)binary, "securityContext.identifier.value", jobParameters.getBinarySecurityContextIdentifierValue());
        }
        DaoMethodOutcome outcome = binaryDao.update((IBaseResource)binary, (RequestDetails)srd);
        IIdType id = outcome.getId();
        BulkExportBinaryFileId bulkExportBinaryFileId = new BulkExportBinaryFileId();
        bulkExportBinaryFileId.setBinaryId(id.getValueAsString());
        bulkExportBinaryFileId.setResourceType(expandedResources.getResourceType());
        theDataSink.accept((IModelJson)bulkExportBinaryFileId);
        ourLog.info("Binary writing complete for {} resources of type {}.", (Object)processedRecordsCount, (Object)expandedResources.getResourceType());
        return new RunOutcome(numResourcesProcessed);
    }

    private void addMetadataExtensionsToBinary(@Nonnull StepExecutionDetails<BulkExportJobParameters, ExpandedResourcesList> theStepExecutionDetails, ExpandedResourcesList expandedResources, IBaseBinary binary) {
        if (binary.getMeta() instanceof IBaseHasExtensions) {
            IBaseHasExtensions meta = (IBaseHasExtensions)binary.getMeta();
            String exportIdentifier = ((BulkExportJobParameters)theStepExecutionDetails.getParameters()).getExportIdentifier();
            if (!StringUtils.isBlank((CharSequence)exportIdentifier)) {
                IBaseExtension exportIdentifierExtension = meta.addExtension();
                exportIdentifierExtension.setUrl("https://hapifhir.org/NamingSystem/bulk-export-identifier");
                exportIdentifierExtension.setValue((IBaseDatatype)this.myFhirContext.newPrimitiveString(exportIdentifier));
            }
            IBaseExtension jobExtension = meta.addExtension();
            jobExtension.setUrl("https://hapifhir.org/NamingSystem/bulk-export-job-id");
            jobExtension.setValue((IBaseDatatype)this.myFhirContext.newPrimitiveString(theStepExecutionDetails.getInstance().getInstanceId()));
            IBaseExtension typeExtension = meta.addExtension();
            typeExtension.setUrl("https://hapifhir.org/NamingSystem/bulk-export-binary-resource-type");
            typeExtension.setValue((IBaseDatatype)this.myFhirContext.newPrimitiveString(expandedResources.getResourceType()));
        } else {
            ourLog.warn("Could not attach metadata extensions to binary resource, as this binary metadata does not support extensions");
        }
    }

    protected OutputStreamWriter getStreamWriter(ByteArrayOutputStream theOutputStream) {
        return new OutputStreamWriter((OutputStream)theOutputStream, Constants.CHARSET_UTF8);
    }
}

