/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.expunge;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.jobs.chunk.ChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.expunge.DeleteExpungeJobParameters;
import ca.uhn.fhir.batch2.jobs.expunge.DeleteExpungeJobParametersValidator;
import ca.uhn.fhir.batch2.jobs.expunge.DeleteExpungeProvider;
import ca.uhn.fhir.batch2.jobs.expunge.DeleteExpungeStep;
import ca.uhn.fhir.batch2.jobs.parameters.IUrlListValidator;
import ca.uhn.fhir.batch2.jobs.parameters.UrlListValidator;
import ca.uhn.fhir.batch2.jobs.step.GenerateRangeChunksStep;
import ca.uhn.fhir.batch2.jobs.step.LoadIdsStep;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import ca.uhn.fhir.jpa.api.svc.IDeleteExpungeSvc;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DeleteExpungeAppCtx {
    public static final String JOB_DELETE_EXPUNGE = "DELETE_EXPUNGE";

    @Bean
    public JobDefinition<DeleteExpungeJobParameters> expungeJobDefinition(IBatch2DaoSvc theBatch2DaoSvc, HapiTransactionService theHapiTransactionService, IDeleteExpungeSvc<?> theDeleteExpungeSvc, IIdHelperService<?> theIdHelperService, IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        return JobDefinition.newBuilder().setJobDefinitionId(JOB_DELETE_EXPUNGE).setJobDescription("Expunge resources").setJobDefinitionVersion(1).setParametersType(DeleteExpungeJobParameters.class).setParametersValidator((IJobParametersValidator)this.expungeJobParametersValidator(theBatch2DaoSvc, theDeleteExpungeSvc, theRequestPartitionHelperSvc)).gatedExecution().addFirstStep("generate-ranges", "Generate data ranges to expunge", ChunkRangeJson.class, this.expungeGenerateRangeChunksStep()).addIntermediateStep("load-ids", "Load IDs of resources to expunge", ResourceIdListWorkChunkJson.class, this.expungeLoadIdsStep(theBatch2DaoSvc)).addLastStep("expunge", "Perform the resource expunge", (IJobStepWorker)this.expungeStep(theHapiTransactionService, theDeleteExpungeSvc, theIdHelperService)).build();
    }

    @Bean
    public DeleteExpungeJobParametersValidator expungeJobParametersValidator(IBatch2DaoSvc theBatch2DaoSvc, IDeleteExpungeSvc<?> theDeleteExpungeSvc, IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        return new DeleteExpungeJobParametersValidator((IUrlListValidator)new UrlListValidator("$expunge", theBatch2DaoSvc), theDeleteExpungeSvc, theRequestPartitionHelperSvc);
    }

    @Bean
    public LoadIdsStep<DeleteExpungeJobParameters> expungeLoadIdsStep(IBatch2DaoSvc theBatch2DaoSvc) {
        return new LoadIdsStep(theBatch2DaoSvc);
    }

    @Bean
    public DeleteExpungeStep expungeStep(HapiTransactionService theHapiTransactionService, IDeleteExpungeSvc<?> theDeleteExpungeSvc, IIdHelperService<?> theIdHelperService) {
        return new DeleteExpungeStep(theHapiTransactionService, theDeleteExpungeSvc, theIdHelperService);
    }

    @Bean
    public GenerateRangeChunksStep<DeleteExpungeJobParameters> expungeGenerateRangeChunksStep() {
        return new GenerateRangeChunksStep();
    }

    @Bean
    public DeleteExpungeProvider deleteExpungeProvider(FhirContext theFhirContext, IDeleteExpungeJobSubmitter theDeleteExpungeJobSubmitter) {
        return new DeleteExpungeProvider(theFhirContext, theDeleteExpungeJobSubmitter);
    }
}

