/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.expunge;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.jobs.expunge.DeleteExpungeJobParameters;
import ca.uhn.fhir.batch2.jobs.parameters.IUrlListValidator;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.jpa.api.svc.IDeleteExpungeSvc;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.ValidateUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

public class DeleteExpungeJobParametersValidator
implements IJobParametersValidator<DeleteExpungeJobParameters> {
    private final IUrlListValidator myUrlListValidator;
    private final IDeleteExpungeSvc<?> myDeleteExpungeSvc;
    private final IRequestPartitionHelperSvc myRequestPartitionHelperSvc;

    public DeleteExpungeJobParametersValidator(IUrlListValidator theUrlListValidator, IDeleteExpungeSvc<?> theDeleteExpungeSvc, IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        this.myUrlListValidator = theUrlListValidator;
        this.myDeleteExpungeSvc = theDeleteExpungeSvc;
        this.myRequestPartitionHelperSvc = theRequestPartitionHelperSvc;
    }

    @Nullable
    public List<String> validate(RequestDetails theRequestDetails, @Nonnull DeleteExpungeJobParameters theParameters) {
        if (theParameters.isCascade() && !this.myDeleteExpungeSvc.isCascadeSupported()) {
            return List.of("Cascading delete is not supported on this server");
        }
        for (PartitionedUrl partitionedUrl : theParameters.getPartitionedUrls()) {
            String url = partitionedUrl.getUrl();
            ValidateUtil.isTrueOrThrowInvalidRequest((boolean)url.matches("[a-zA-Z]+\\?.*"), (String)"Delete expunge URLs must be in the format [resourceType]?[parameters]", (Object[])new Object[0]);
            if (partitionedUrl.getRequestPartitionId() == null) continue;
            this.myRequestPartitionHelperSvc.validateHasPartitionPermissions(theRequestDetails, null, partitionedUrl.getRequestPartitionId());
        }
        return this.myUrlListValidator.validateUrls(theParameters.getUrls());
    }
}

