/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.expunge;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.jobs.expunge.DeleteExpungeJobParameters;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.batch2.jobs.parameters.UrlPartitioner;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DeleteExpungeJobSubmitterImpl
implements IDeleteExpungeJobSubmitter {
    @Autowired
    IJobCoordinator myJobCoordinator;
    @Autowired
    IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    JpaStorageSettings myStorageSettings;
    @Autowired
    IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    UrlPartitioner myUrlPartitioner;

    @Transactional(propagation=Propagation.NEVER)
    public String submitJob(Integer theBatchSize, List<String> theUrlsToDeleteExpunge, boolean theCascade, Integer theCascadeMaxRounds, RequestDetails theRequestDetails) {
        if (theBatchSize == null) {
            theBatchSize = this.myStorageSettings.getExpungeBatchSize();
        }
        if (!this.myStorageSettings.canDeleteExpunge()) {
            throw new ForbiddenOperationException(Msg.code((int)820) + "Delete Expunge not allowed:  " + this.myStorageSettings.cannotDeleteExpungeReason());
        }
        for (String url2 : theUrlsToDeleteExpunge) {
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(String.class, (Object)url2);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PRE_DELETE_EXPUNGE, (HookParams)params);
        }
        DeleteExpungeJobParameters deleteExpungeJobParameters = new DeleteExpungeJobParameters();
        theUrlsToDeleteExpunge.stream().filter(StringUtils::isNotBlank).map(url -> this.myUrlPartitioner.partitionUrl(url, theRequestDetails)).forEach(arg_0 -> ((DeleteExpungeJobParameters)deleteExpungeJobParameters).addPartitionedUrl(arg_0));
        deleteExpungeJobParameters.setBatchSize(theBatchSize);
        if (theUrlsToDeleteExpunge.isEmpty()) {
            RequestPartitionId requestPartition = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForServerOperation(theRequestDetails, "$delete-expunge");
            deleteExpungeJobParameters.addPartitionedUrl(new PartitionedUrl().setRequestPartitionId(requestPartition));
        }
        deleteExpungeJobParameters.setCascade(theCascade);
        deleteExpungeJobParameters.setCascadeMaxRounds(theCascadeMaxRounds);
        JobInstanceStartRequest startRequest = new JobInstanceStartRequest();
        startRequest.setJobDefinitionId("DELETE_EXPUNGE");
        startRequest.setParameters((IModelJson)deleteExpungeJobParameters);
        Batch2JobStartResponse startResponse = this.myJobCoordinator.startInstance(theRequestDetails, startRequest);
        return startResponse.getInstanceId();
    }
}

