/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.expunge;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DeleteExpungeProvider {
    private final FhirContext myFhirContext;
    private final IDeleteExpungeJobSubmitter myDeleteExpungeJobSubmitter;

    public DeleteExpungeProvider(FhirContext theFhirContext, IDeleteExpungeJobSubmitter theDeleteExpungeJobSubmitter) {
        this.myFhirContext = theFhirContext;
        this.myDeleteExpungeJobSubmitter = theDeleteExpungeJobSubmitter;
    }

    @Operation(name="$delete-expunge", idempotent=false)
    public IBaseParameters deleteExpunge(@OperationParam(name="url", typeName="string", min=1) List<IPrimitiveType<String>> theUrlsToDeleteExpunge, @OperationParam(name="batchSize", typeName="integer", min=0, max=1) IPrimitiveType<Integer> theBatchSize, @OperationParam(name="cascade", typeName="boolean", min=0, max=1) IPrimitiveType<Boolean> theCascade, @OperationParam(name="cascadeMaxRounds", typeName="integer", min=0, max=1) IPrimitiveType<Integer> theCascadeMaxRounds, RequestDetails theRequestDetails) {
        if (theUrlsToDeleteExpunge == null) {
            throw new InvalidRequestException(Msg.code((int)2101) + "At least one `url` parameter to $delete-expunge must be provided.");
        }
        List urls = theUrlsToDeleteExpunge.stream().map(IPrimitiveType::getValue).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Integer batchSize = null;
        if (theBatchSize != null && theBatchSize.getValue() != null && (Integer)theBatchSize.getValue() > 0) {
            batchSize = (Integer)theBatchSize.getValue();
        }
        boolean cascase = false;
        if (theCascade != null && theCascade.hasValue()) {
            cascase = (Boolean)theCascade.getValue();
        }
        Integer cascadeMaxRounds = null;
        if (theCascadeMaxRounds != null) {
            cascadeMaxRounds = (Integer)theCascadeMaxRounds.getValue();
        }
        String jobId = this.myDeleteExpungeJobSubmitter.submitJob(batchSize, urls, cascase, cascadeMaxRounds, theRequestDetails);
        IBaseParameters retval = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myFhirContext, (IBaseParameters)retval, (String)"jobId", (String)jobId);
        return retval;
    }
}

