/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.expunge;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.expunge.DeleteExpungeJobParameters;
import ca.uhn.fhir.jpa.api.svc.IDeleteExpungeSvc;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class DeleteExpungeStep
implements IJobStepWorker<DeleteExpungeJobParameters, ResourceIdListWorkChunkJson, VoidModel> {
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteExpungeStep.class);
    private final HapiTransactionService myHapiTransactionService;
    private final IDeleteExpungeSvc myDeleteExpungeSvc;
    private final IIdHelperService myIdHelperService;

    public DeleteExpungeStep(HapiTransactionService theHapiTransactionService, IDeleteExpungeSvc theDeleteExpungeSvc, IIdHelperService theIdHelperService) {
        this.myHapiTransactionService = theHapiTransactionService;
        this.myDeleteExpungeSvc = theDeleteExpungeSvc;
        this.myIdHelperService = theIdHelperService;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<DeleteExpungeJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        ResourceIdListWorkChunkJson data = (ResourceIdListWorkChunkJson)theStepExecutionDetails.getData();
        boolean cascade = ((DeleteExpungeJobParameters)theStepExecutionDetails.getParameters()).isCascade();
        Integer cascadeMaxRounds = ((DeleteExpungeJobParameters)theStepExecutionDetails.getParameters()).getCascadeMaxRounds();
        return this.doDeleteExpunge(data, theDataSink, theStepExecutionDetails.getInstance().getInstanceId(), theStepExecutionDetails.getChunkId(), cascade, cascadeMaxRounds);
    }

    @Nonnull
    public RunOutcome doDeleteExpunge(ResourceIdListWorkChunkJson theData, IJobDataSink<VoidModel> theDataSink, String theInstanceId, String theChunkId, boolean theCascade, Integer theCascadeMaxRounds) {
        SystemRequestDetails requestDetails = new SystemRequestDetails();
        TransactionDetails transactionDetails = new TransactionDetails();
        DeleteExpungeJob job = new DeleteExpungeJob(theData, (RequestDetails)requestDetails, transactionDetails, theDataSink, theInstanceId, theChunkId, theCascade, theCascadeMaxRounds);
        this.myHapiTransactionService.withRequest((RequestDetails)requestDetails).withTransactionDetails(transactionDetails).withRequestPartitionId(theData.getRequestPartitionId()).execute((TransactionCallback)job);
        return new RunOutcome(job.getRecordCount());
    }

    private class DeleteExpungeJob
    implements TransactionCallback<Void> {
        private final ResourceIdListWorkChunkJson myData;
        private final RequestDetails myRequestDetails;
        private final TransactionDetails myTransactionDetails;
        private final IJobDataSink<VoidModel> myDataSink;
        private final String myChunkId;
        private final String myInstanceId;
        private final boolean myCascade;
        private final Integer myCascadeMaxRounds;
        private int myRecordCount;

        public DeleteExpungeJob(ResourceIdListWorkChunkJson theData, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, IJobDataSink<VoidModel> theDataSink, String theInstanceId, String theChunkId, boolean theCascade, Integer theCascadeMaxRounds) {
            this.myData = theData;
            this.myRequestDetails = theRequestDetails;
            this.myTransactionDetails = theTransactionDetails;
            this.myDataSink = theDataSink;
            this.myInstanceId = theInstanceId;
            this.myChunkId = theChunkId;
            this.myCascade = theCascade;
            this.myCascadeMaxRounds = theCascadeMaxRounds;
        }

        public int getRecordCount() {
            return this.myRecordCount;
        }

        public Void doInTransaction(@Nonnull TransactionStatus theStatus) {
            List persistentIds = this.myData.getResourcePersistentIds(DeleteExpungeStep.this.myIdHelperService);
            if (persistentIds.isEmpty()) {
                ourLog.info("Starting delete expunge work chunk.  There are no resources to delete expunge - Instance[{}] Chunk[{}]", (Object)this.myInstanceId, (Object)this.myChunkId);
                return null;
            }
            ourLog.info("Starting delete expunge work chunk with {} resources - Instance[{}] Chunk[{}]", new Object[]{persistentIds.size(), this.myInstanceId, this.myChunkId});
            this.myRecordCount = DeleteExpungeStep.this.myDeleteExpungeSvc.deleteExpunge(persistentIds, this.myCascade, this.myCascadeMaxRounds);
            return null;
        }
    }
}

