/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.importpull;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.importpull.models.Batch2BulkImportPullJobParameters;
import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobJson;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImportParameterValidator
implements IJobParametersValidator<Batch2BulkImportPullJobParameters> {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkImportParameterValidator.class);
    private final IBulkDataImportSvc myBulkDataImportSvc;

    public BulkImportParameterValidator(IBulkDataImportSvc theIBulkDataImportSvc) {
        this.myBulkDataImportSvc = theIBulkDataImportSvc;
    }

    @Nullable
    public List<String> validate(RequestDetails theRequestDetails, @Nonnull Batch2BulkImportPullJobParameters theParameters) {
        String jobId;
        ourLog.info("BulkImportPull parameter validation begin");
        ArrayList<String> errors = new ArrayList<String>();
        if (theParameters.getBatchSize() <= 0L) {
            errors.add("Batch size must be positive");
        }
        if (StringUtils.isEmpty((CharSequence)(jobId = theParameters.getJobId()))) {
            errors.add("Bulk Import Pull requires an existing job id");
        } else {
            BulkImportJobJson job = this.myBulkDataImportSvc.fetchJob(jobId);
            if (job == null) {
                errors.add("There is no persistent job that exists with UUID: " + jobId);
            }
        }
        ourLog.info("BulkImportPull parameter validation end");
        return errors;
    }
}

