/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.importpull;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.importpull.models.Batch2BulkImportPullJobParameters;
import ca.uhn.fhir.batch2.importpull.models.BulkImportFilePartitionResult;
import ca.uhn.fhir.batch2.importpull.models.BulkImportRecord;
import ca.uhn.fhir.batch2.jobs.importpull.BulkImportParameterValidator;
import ca.uhn.fhir.batch2.jobs.importpull.FetchPartitionedFilesStep;
import ca.uhn.fhir.batch2.jobs.importpull.ReadInResourcesFromFileStep;
import ca.uhn.fhir.batch2.jobs.importpull.WriteBundleForImportStep;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BulkImportPullConfig {
    public static final String BULK_IMPORT_JOB_NAME = "bulkImportJob";
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IBulkDataImportSvc myBulkDataImportSvc;

    @Bean
    public JobDefinition bulkImportPullJobDefinition() {
        return JobDefinition.newBuilder().setJobDefinitionId(BULK_IMPORT_JOB_NAME).setJobDescription("Performs bulk import pull job").setJobDefinitionVersion(1).gatedExecution().setParametersType(Batch2BulkImportPullJobParameters.class).setParametersValidator((IJobParametersValidator)this.importParameterValidator()).addFirstStep("FetchPartitionedFilesStep", "Reads an import file and extracts the resources", BulkImportFilePartitionResult.class, (IJobStepWorker)this.fetchPartitionedFilesStep()).addIntermediateStep("ReadInResourcesFromFileStep", "Reads the import file to get the serialized bundles", BulkImportRecord.class, (IJobStepWorker)this.readInResourcesFromFileStep()).addLastStep("WriteBundleForImportStep", "Parses the bundle from previous step and writes it to the dv", (IJobStepWorker)this.writeBundleForImportStep()).build();
    }

    @Bean
    public BulkImportParameterValidator importParameterValidator() {
        return new BulkImportParameterValidator(this.myBulkDataImportSvc);
    }

    @Bean
    public FetchPartitionedFilesStep fetchPartitionedFilesStep() {
        return new FetchPartitionedFilesStep(this.myBulkDataImportSvc);
    }

    @Bean
    public ReadInResourcesFromFileStep readInResourcesFromFileStep() {
        return new ReadInResourcesFromFileStep(this.myBulkDataImportSvc);
    }

    @Bean
    public WriteBundleForImportStep writeBundleForImportStep() {
        return new WriteBundleForImportStep(this.myFhirContext, this.myDaoRegistry);
    }
}

