/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.importpull;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.importpull.models.Batch2BulkImportPullJobParameters;
import ca.uhn.fhir.batch2.importpull.models.BulkImportFilePartitionResult;
import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobJson;
import ca.uhn.fhir.model.api.IModelJson;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchPartitionedFilesStep
implements IFirstJobStepWorker<Batch2BulkImportPullJobParameters, BulkImportFilePartitionResult> {
    private static final Logger ourLog = LoggerFactory.getLogger(FetchPartitionedFilesStep.class);
    private final IBulkDataImportSvc myBulkDataImportSvc;

    public FetchPartitionedFilesStep(IBulkDataImportSvc theBulkDataImportSvc) {
        this.myBulkDataImportSvc = theBulkDataImportSvc;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<Batch2BulkImportPullJobParameters, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<BulkImportFilePartitionResult> theDataSink) throws JobExecutionFailedException {
        String jobId = ((Batch2BulkImportPullJobParameters)theStepExecutionDetails.getParameters()).getJobId();
        ourLog.info("Start FetchPartitionedFilesStep for jobID {} ", (Object)jobId);
        BulkImportJobJson job = this.myBulkDataImportSvc.fetchJob(jobId);
        for (int i = 0; i < job.getFileCount(); ++i) {
            String fileDescription = this.myBulkDataImportSvc.getFileDescription(jobId, i);
            BulkImportFilePartitionResult result = new BulkImportFilePartitionResult();
            result.setFileIndex(i);
            result.setProcessingMode(job.getProcessingMode());
            result.setFileDescription(fileDescription);
            result.setJobDescription(job.getJobDescription());
            theDataSink.accept((IModelJson)result);
        }
        ourLog.info("FetchPartitionedFilesStep complete for jobID {}.  Submitted {} files to next step.", (Object)jobId, (Object)job.getFileCount());
        return RunOutcome.SUCCESS;
    }
}

