/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.importpull;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.importpull.models.Batch2BulkImportPullJobParameters;
import ca.uhn.fhir.batch2.importpull.models.BulkImportFilePartitionResult;
import ca.uhn.fhir.batch2.importpull.models.BulkImportRecord;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobFileJson;
import ca.uhn.fhir.jpa.bulk.imprt.model.JobFileRowProcessingModeEnum;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.IoUtil;
import com.google.common.io.LineReader;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadInResourcesFromFileStep
implements IJobStepWorker<Batch2BulkImportPullJobParameters, BulkImportFilePartitionResult, BulkImportRecord> {
    private static final Logger ourLog = LoggerFactory.getLogger(ReadInResourcesFromFileStep.class);
    private final IBulkDataImportSvc myBulkDataImportSvc;

    public ReadInResourcesFromFileStep(IBulkDataImportSvc theBulkDataImportSvc) {
        this.myBulkDataImportSvc = theBulkDataImportSvc;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<Batch2BulkImportPullJobParameters, BulkImportFilePartitionResult> theStepExecutionDetails, @Nonnull IJobDataSink<BulkImportRecord> theDataSink) throws JobExecutionFailedException {
        String jobId = ((Batch2BulkImportPullJobParameters)theStepExecutionDetails.getParameters()).getJobId();
        int fileIndex = ((BulkImportFilePartitionResult)theStepExecutionDetails.getData()).getFileIndex();
        JobFileRowProcessingModeEnum mode = ((BulkImportFilePartitionResult)theStepExecutionDetails.getData()).getProcessingMode();
        ourLog.info("ReadInResourcesFromFileStep for jobId {} begin", (Object)jobId);
        BulkImportJobFileJson file = this.myBulkDataImportSvc.fetchFile(jobId, fileIndex);
        String tenantName = file.getTenantName();
        String contents = file.getContents();
        StringReader reader = new StringReader(contents);
        LineReader lineReader = new LineReader((Readable)reader);
        try {
            String nextLine;
            int lineIndex = 0;
            do {
                if ((nextLine = lineReader.readLine()) != null) {
                    BulkImportRecord record = new BulkImportRecord();
                    record.setResourceString(nextLine);
                    record.setLineIndex(lineIndex);
                    record.setTenantName(tenantName);
                    record.setProcessingMode(mode);
                    record.setFileIndex(fileIndex);
                    theDataSink.accept((IModelJson)record);
                }
                ++lineIndex;
            } while (nextLine != null);
        }
        catch (IOException ex) {
            ourLog.error("Failed to read file : " + ex.getMessage());
            throw new JobExecutionFailedException(Msg.code((int)2107) + " : Could not read file");
        }
        finally {
            IoUtil.closeQuietly((AutoCloseable)reader);
        }
        ourLog.info("ReadInResourcesFromFileStep for jobId {} end", (Object)jobId);
        return RunOutcome.SUCCESS;
    }
}

