/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.importpull;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.ILastJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.importpull.models.Batch2BulkImportPullJobParameters;
import ca.uhn.fhir.batch2.importpull.models.BulkImportRecord;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.bulk.imprt.model.JobFileRowProcessingModeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBundleForImportStep
implements ILastJobStepWorker<Batch2BulkImportPullJobParameters, BulkImportRecord> {
    private static final Logger ourLog = LoggerFactory.getLogger(WriteBundleForImportStep.class);
    private final FhirContext myFhirContext;
    private final DaoRegistry myDaoRegistry;

    public WriteBundleForImportStep(FhirContext theFhirContext, DaoRegistry theDaoRegistry) {
        this.myFhirContext = theFhirContext;
        this.myDaoRegistry = theDaoRegistry;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<Batch2BulkImportPullJobParameters, BulkImportRecord> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        BulkImportRecord record = (BulkImportRecord)theStepExecutionDetails.getData();
        JobFileRowProcessingModeEnum mode = record.getProcessingMode();
        int fileIndex = record.getFileIndex();
        String content = record.getResourceString();
        String tenantName = record.getTenantName();
        int lineIndex = record.getLineIndex();
        String jobId = ((Batch2BulkImportPullJobParameters)theStepExecutionDetails.getParameters()).getJobId();
        ourLog.info("Beginning bulk import write row {} for Job[{}] FileIndex[{}]", new Object[]{lineIndex, jobId, fileIndex});
        IParser parser = this.myFhirContext.newJsonParser();
        SystemRequestDetails requestDetails = new SystemRequestDetails();
        requestDetails.setTenantId(tenantName);
        IBaseResource bundle = parser.parseResource(content);
        switch (mode) {
            default: 
        }
        IFhirSystemDao systemDao = this.myDaoRegistry.getSystemDao();
        systemDao.transaction((RequestDetails)requestDetails, (Object)bundle);
        ourLog.info("Completed bulk import write for row {} Job[{}] FileIndex[{}]", new Object[]{lineIndex, jobId, fileIndex});
        return RunOutcome.SUCCESS;
    }
}

