/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.imprt;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.jobs.export.BulkDataExportProvider;
import ca.uhn.fhir.batch2.jobs.imprt.BulkImportJobParameters;
import ca.uhn.fhir.batch2.jobs.imprt.ResourceOrderUtil;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.ValidateUtil;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkDataImportProvider {
    public static final String PARAM_INPUT_FORMAT = "inputFormat";
    public static final String PARAM_INPUT_SOURCE = "inputSource";
    public static final String PARAM_STORAGE_DETAIL = "storageDetail";
    public static final String PARAM_STORAGE_DETAIL_TYPE = "type";
    public static final String PARAM_STORAGE_DETAIL_TYPE_VAL_HTTPS = "https";
    public static final String PARAM_INPUT = "input";
    public static final String PARAM_INPUT_URL = "url";
    public static final String PARAM_STORAGE_DETAIL_CREDENTIAL_HTTP_BASIC = "credentialHttpBasic";
    public static final String PARAM_STORAGE_DETAIL_MAX_BATCH_RESOURCE_COUNT = "maxBatchResourceCount";
    public static final String PARAM_INPUT_TYPE = "type";
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataImportProvider.class);
    private IJobCoordinator myJobCoordinator;
    private FhirContext myFhirCtx;
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    private volatile List<String> myResourceTypeOrder;

    @Autowired
    public void setJobCoordinator(IJobCoordinator theJobCoordinator) {
        this.myJobCoordinator = theJobCoordinator;
    }

    @Autowired
    public void setFhirContext(FhirContext theCtx) {
        this.myFhirCtx = theCtx;
    }

    @Autowired
    public void setRequestPartitionHelperService(IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        this.myRequestPartitionHelperService = theRequestPartitionHelperSvc;
    }

    @Operation(name="$import", idempotent=false, manualResponse=true)
    public void importByManifest(ServletRequestDetails theRequestDetails, @ResourceParam IBaseParameters theRequest, HttpServletResponse theResponse) throws IOException {
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$import");
        BulkImportJobParameters jobParameters = new BulkImportJobParameters();
        String inputFormat = ParametersUtil.getNamedParameterValueAsString((FhirContext)this.myFhirCtx, (IBaseParameters)theRequest, (String)PARAM_INPUT_FORMAT).orElse("");
        if (!"application/fhir+ndjson".equals(inputFormat)) {
            throw new InvalidRequestException(Msg.code((int)2048) + "Input format must be \"application/fhir+ndjson\"");
        }
        Optional storageDetailOpt = ParametersUtil.getNamedParameter((FhirContext)this.myFhirCtx, (IBaseResource)theRequest, (String)PARAM_STORAGE_DETAIL);
        if (storageDetailOpt.isPresent()) {
            Object maximumBatchResourceCount;
            IBase storageDetail = (IBase)storageDetailOpt.get();
            String httpBasicCredential = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myFhirCtx, (IBase)storageDetail, (String)PARAM_STORAGE_DETAIL_CREDENTIAL_HTTP_BASIC);
            if (StringUtils.isNotBlank((CharSequence)httpBasicCredential)) {
                jobParameters.setHttpBasicCredentials(httpBasicCredential);
            }
            if (StringUtils.isNotBlank((CharSequence)(maximumBatchResourceCount = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myFhirCtx, (IBase)storageDetail, (String)PARAM_STORAGE_DETAIL_MAX_BATCH_RESOURCE_COUNT)))) {
                jobParameters.setMaxBatchResourceCount(Integer.parseInt((String)maximumBatchResourceCount));
            }
        }
        RequestPartitionId partitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForServerOperation((RequestDetails)theRequestDetails, "$import");
        this.myRequestPartitionHelperService.validateHasPartitionPermissions((RequestDetails)theRequestDetails, "Binary", partitionId);
        jobParameters.setPartitionId(partitionId);
        ArrayList<Pair> typeAndUrls = new ArrayList<Pair>();
        for (Object input : ParametersUtil.getNamedParameters((FhirContext)this.myFhirCtx, (IBaseResource)theRequest, (String)PARAM_INPUT)) {
            String type = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myFhirCtx, (IBase)input, (String)"type");
            String url = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myFhirCtx, (IBase)input, (String)PARAM_INPUT_URL);
            ValidateUtil.isNotBlankOrThrowInvalidRequest((String)type, (String)"Missing type for input");
            ValidateUtil.isNotBlankOrThrowInvalidRequest((String)url, (String)"Missing url for input");
            Pair typeAndUrl = Pair.of((Object)type, (Object)url);
            typeAndUrls.add(typeAndUrl);
        }
        ValidateUtil.isTrueOrThrowInvalidRequest((typeAndUrls.size() > 0 ? 1 : 0) != 0, (String)"No URLs specified", (Object[])new Object[0]);
        List<String> resourceTypeOrder = this.getResourceTypeOrder();
        typeAndUrls.sort(Comparator.comparing(t -> resourceTypeOrder.indexOf(t.getKey())));
        for (Pair next : typeAndUrls) {
            jobParameters.addNdJsonUrl((String)next.getValue());
        }
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setJobDefinitionId("BULK_IMPORT_PULL");
        request.setParameters((IModelJson)jobParameters);
        ourLog.info("Requesting Bulk Import Job ($import by Manifest) with {} urls", (Object)typeAndUrls.size());
        Batch2JobStartResponse jobStartResponse = this.myJobCoordinator.startInstance((RequestDetails)theRequestDetails, request);
        String jobId = jobStartResponse.getInstanceId();
        IBaseOperationOutcome response = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirCtx);
        OperationOutcomeUtil.addIssue((FhirContext)this.myFhirCtx, (IBaseOperationOutcome)response, (String)"information", (String)("Bulk import job has been submitted with ID: " + jobId), null, (String)"informational");
        OperationOutcomeUtil.addIssue((FhirContext)this.myFhirCtx, (IBaseOperationOutcome)response, (String)"information", (String)("Use the following URL to poll for job status: " + this.createPollLocationLink(theRequestDetails, jobId)), null, (String)"informational");
        theResponse.setStatus(202);
        theResponse.setContentType("application/json+fhir; charset=UTF-8");
        this.writePollingLocationToResponseHeaders(theRequestDetails, jobId);
        this.myFhirCtx.newJsonParser().setPrettyPrint(true).encodeResourceToWriter((IBaseResource)response, (Writer)theResponse.getWriter());
        theResponse.getWriter().close();
    }

    @Operation(name="$import-poll-status", manualResponse=true, idempotent=true)
    public void importPollStatus(@OperationParam(name="_jobId", typeName="string", min=0, max=1) IPrimitiveType<String> theJobId, ServletRequestDetails theRequestDetails) throws IOException {
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        JobInstance instance = this.myJobCoordinator.getInstance(theJobId.getValueAsString());
        BulkImportJobParameters parameters = (BulkImportJobParameters)instance.getParameters(BulkImportJobParameters.class);
        if (parameters != null && parameters.getPartitionId() != null) {
            RequestPartitionId partitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForServerOperation((RequestDetails)theRequestDetails, "$import");
            this.myRequestPartitionHelperService.validateHasPartitionPermissions((RequestDetails)theRequestDetails, "Binary", partitionId);
            if (!partitionId.equals((Object)parameters.getPartitionId())) {
                throw new InvalidRequestException(Msg.code((int)2310) + "Invalid partition in request for Job ID " + theJobId);
            }
        }
        switch (instance.getStatus()) {
            case QUEUED: {
                response.setStatus(202);
                String msg = "Job was created at " + BulkDataImportProvider.renderTime(instance.getCreateTime()) + " and is in " + instance.getStatus() + " state.";
                response.addHeader("X-Progress", msg);
                response.addHeader("Retry-After", "120");
                this.streamOperationOutcomeResponse(response, msg, "information");
                break;
            }
            case ERRORED: 
            case IN_PROGRESS: {
                response.setStatus(202);
                String msg = "Job was created at " + BulkDataImportProvider.renderTime(instance.getCreateTime()) + ", started at " + BulkDataImportProvider.renderTime(instance.getStartTime()) + " and is in " + instance.getStatus() + " state. Current completion: " + new DecimalFormat("0.0").format(100.0 * instance.getProgress()) + "% and ETA is " + instance.getEstimatedTimeRemaining();
                response.addHeader("X-Progress", msg);
                response.addHeader("Retry-After", "120");
                this.streamOperationOutcomeResponse(response, msg, "information");
                break;
            }
            case COMPLETED: {
                response.setStatus(200);
                String msg = "Job is complete.";
                this.streamOperationOutcomeResponse(response, msg, "information");
                break;
            }
            case FAILED: {
                response.setStatus(500);
                String msg = "Job is in " + instance.getStatus() + " state with " + instance.getErrorCount() + " error count. Last error: " + instance.getErrorMessage();
                this.streamOperationOutcomeResponse(response, msg, "error");
                break;
            }
            case CANCELLED: {
                response.setStatus(404);
                String msg = "Job was cancelled.";
                this.streamOperationOutcomeResponse(response, msg, "information");
                break;
            }
        }
    }

    private void streamOperationOutcomeResponse(HttpServletResponse response, String theMessage, String theSeverity) throws IOException {
        response.setContentType("application/json+fhir");
        IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirCtx);
        OperationOutcomeUtil.addIssue((FhirContext)this.myFhirCtx, (IBaseOperationOutcome)oo, (String)theSeverity, (String)theMessage, null, null);
        this.myFhirCtx.newJsonParser().setPrettyPrint(true).encodeResourceToWriter((IBaseResource)oo, (Writer)response.getWriter());
        response.getWriter().close();
    }

    public void writePollingLocationToResponseHeaders(ServletRequestDetails theRequestDetails, String theJobId) {
        String pollLocation = this.createPollLocationLink(theRequestDetails, theJobId);
        pollLocation = UrlUtil.sanitizeHeaderValue((String)pollLocation);
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        response.addHeader("Content-Location", pollLocation);
        response.setStatus(202);
    }

    @Nonnull
    private String createPollLocationLink(ServletRequestDetails theRequestDetails, String theJobId) {
        String serverBase = StringUtils.removeEnd((String)theRequestDetails.getServerBaseForRequest(), (String)"/");
        return serverBase + "/$import-poll-status?_jobId=" + theJobId;
    }

    private synchronized List<String> getResourceTypeOrder() {
        List<String> retVal = this.myResourceTypeOrder;
        if (retVal == null) {
            this.myResourceTypeOrder = retVal = ResourceOrderUtil.getResourceOrder(this.myFhirCtx);
        }
        return retVal;
    }

    private static String renderTime(Date theTime) {
        if (theTime == null) {
            return "(null)";
        }
        return new InstantType(theTime).getValueAsString();
    }
}

