/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.imprt;

import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.imprt.BulkDataImportProvider;
import ca.uhn.fhir.batch2.jobs.imprt.BulkImportJobParameters;
import ca.uhn.fhir.batch2.jobs.imprt.ConsumeFilesStep;
import ca.uhn.fhir.batch2.jobs.imprt.FetchFilesStep;
import ca.uhn.fhir.batch2.jobs.imprt.NdJsonFileJson;
import ca.uhn.fhir.batch2.model.JobDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BulkImportAppCtx {
    public static final String JOB_BULK_IMPORT_PULL = "BULK_IMPORT_PULL";
    public static final int PARAM_MAXIMUM_BATCH_SIZE_DEFAULT = 800;

    @Bean
    public JobDefinition<BulkImportJobParameters> bulkImport2JobDefinition() {
        return JobDefinition.newBuilder().setJobDefinitionId(JOB_BULK_IMPORT_PULL).setJobDescription("FHIR Bulk Import using pull-based data source").setJobDefinitionVersion(1).setParametersType(BulkImportJobParameters.class).addFirstStep("fetch-files", "Fetch files for import", NdJsonFileJson.class, this.bulkImport2FetchFiles()).addLastStep("process-files", "Process files", this.bulkImport2ConsumeFiles()).build();
    }

    @Bean
    public IJobStepWorker<BulkImportJobParameters, VoidModel, NdJsonFileJson> bulkImport2FetchFiles() {
        return new FetchFilesStep();
    }

    @Bean
    public IJobStepWorker<BulkImportJobParameters, NdJsonFileJson, VoidModel> bulkImport2ConsumeFiles() {
        return new ConsumeFilesStep();
    }

    @Bean
    public BulkDataImportProvider bulkImportProvider() {
        return new BulkDataImportProvider();
    }
}

