/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.imprt;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.UrlUtil;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImportFileServlet
extends HttpServlet {
    public static final String INDEX_PARAM = "index";
    private static final long serialVersionUID = 8302513561762436076L;
    private static final Logger ourLog = LoggerFactory.getLogger(BulkImportFileServlet.class);
    private final Map<String, IFileSupplier> myFileIds = new HashMap<String, IFileSupplier>();
    public static final String DEFAULT_HEADER_CONTENT_TYPE = "application/fhir+ndjson; charset=UTF-8";
    private String myBasicAuth;

    public BulkImportFileServlet() {
    }

    public BulkImportFileServlet(String theBasicAuthUsername, String theBasicAuthPassword) {
        this.setBasicAuth(theBasicAuthUsername, theBasicAuthPassword);
    }

    public void setBasicAuth(String username, String password) {
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        this.myBasicAuth = "Basic " + encodedAuth;
    }

    public void checkBasicAuthAndMaybeThrow403(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.myBasicAuth == null || this.myBasicAuth.isEmpty()) {
            return;
        }
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.equals(this.myBasicAuth)) {
            response.sendError(403, "Invalid authentication credentials.");
        }
    }

    protected void doGet(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException {
        this.checkBasicAuthAndMaybeThrow403(theRequest, theResponse);
        try {
            String servletPath = theRequest.getServletPath();
            String requestUri = theRequest.getRequestURI();
            String contextPath = theRequest.getContextPath();
            String requestPath = requestUri.substring(contextPath.length() + servletPath.length());
            if ("/download".equals(requestPath)) {
                this.handleDownload(theRequest, theResponse);
                return;
            }
            throw new ResourceNotFoundException(Msg.code((int)2049) + "Invalid request path: " + requestPath);
        }
        catch (Exception e) {
            ourLog.warn("Failure serving file", (Throwable)e);
            int responseCode = 500;
            if (e instanceof BaseServerResponseException) {
                responseCode = ((BaseServerResponseException)((Object)e)).getStatusCode();
            }
            theResponse.setStatus(responseCode);
            theResponse.addHeader("Content-Type", "text/plain");
            theResponse.getWriter().print("Failed to handle response. See server logs for details.");
            theResponse.getWriter().close();
            return;
        }
    }

    private void handleDownload(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException {
        Closeable reader;
        String indexParam = StringUtils.defaultString((String)theRequest.getParameter(INDEX_PARAM));
        if (StringUtils.isBlank((CharSequence)indexParam)) {
            throw new ResourceNotFoundException(Msg.code((int)2050) + "Missing or invalid index parameter");
        }
        if (!this.myFileIds.containsKey(indexParam)) {
            throw new ResourceNotFoundException(Msg.code((int)2051) + "Invalid index: " + UrlUtil.sanitizeUrlPart((CharSequence)indexParam));
        }
        ourLog.info("Serving Bulk Import NDJSON file index: {}", (Object)indexParam);
        theResponse.addHeader("Content-Type", this.getHeaderContentType());
        IFileSupplier supplier = this.myFileIds.get(indexParam);
        if (supplier.isGzip()) {
            theResponse.addHeader("Content-Encoding", "gzip");
        }
        if (ourLog.isDebugEnabled()) {
            reader = new InputStreamReader(supplier.get());
            try {
                String string = IOUtils.toString((Reader)reader);
                ourLog.debug("file content: {}", (Object)string);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        reader = supplier.get();
        try {
            IOUtils.copy((InputStream)reader, (OutputStream)theResponse.getOutputStream());
        }
        finally {
            if (reader != null) {
                ((InputStream)reader).close();
            }
        }
    }

    public String getHeaderContentType() {
        return DEFAULT_HEADER_CONTENT_TYPE;
    }

    public void clearFiles() {
        this.myFileIds.clear();
    }

    public String registerFile(IFileSupplier theFile) {
        String index = UUID.randomUUID().toString();
        this.myFileIds.put(index, theFile);
        return index;
    }

    public String registerFileByContents(final String theFileContents) {
        return this.registerFile(new IFileSupplier(){

            @Override
            public boolean isGzip() {
                return false;
            }

            @Override
            public InputStream get() {
                return new ReaderInputStream((Reader)new StringReader(theFileContents), StandardCharsets.UTF_8);
            }
        });
    }

    public static interface IFileSupplier {
        public boolean isGzip();

        public InputStream get() throws IOException;
    }
}

