/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.imprt;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.api.annotation.SensitiveNoDisplay;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

@JsonFilter(value="sensitiveDataFilter")
public class BulkImportJobParameters
implements IModelJson {
    @JsonProperty(value="ndJsonUrls", required=true)
    @Size(min=1, message="At least one NDJSON URL must be provided")
    @NotEmpty(message="At least one NDJSON URL must be provided")
    private @Size(min=1, message="At least one NDJSON URL must be provided") @NotEmpty(message="At least one NDJSON URL must be provided") List<@Pattern(regexp="^http[s]?://.*", message="Must be a valid URL") String> myNdJsonUrls;
    @JsonProperty(value="httpBasicCredentials", required=false)
    @Nullable
    @SensitiveNoDisplay
    private String myHttpBasicCredentials;
    @JsonProperty(value="maxBatchResourceCount", required=false)
    @Min(value=1L)
    @Nullable
    private @Min(value=1L) Integer myMaxBatchResourceCount;
    @JsonProperty(value="partitionId", required=false)
    @Nullable
    private RequestPartitionId myPartitionId;

    public List<String> getNdJsonUrls() {
        if (this.myNdJsonUrls == null) {
            this.myNdJsonUrls = new ArrayList<String>();
        }
        return this.myNdJsonUrls;
    }

    public String getHttpBasicCredentials() {
        return this.myHttpBasicCredentials;
    }

    public BulkImportJobParameters setHttpBasicCredentials(String theHttpBasicCredentials) {
        this.myHttpBasicCredentials = theHttpBasicCredentials;
        return this;
    }

    @Nullable
    public Integer getMaxBatchResourceCount() {
        return this.myMaxBatchResourceCount;
    }

    public BulkImportJobParameters setMaxBatchResourceCount(@Nullable Integer theMaxBatchResourceCount) {
        this.myMaxBatchResourceCount = theMaxBatchResourceCount;
        return this;
    }

    public BulkImportJobParameters addNdJsonUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        this.getNdJsonUrls().add(theUrl);
        return this;
    }

    @Nullable
    public RequestPartitionId getPartitionId() {
        return this.myPartitionId;
    }

    public BulkImportJobParameters setPartitionId(@Nullable RequestPartitionId thePartitionId) {
        this.myPartitionId = thePartitionId;
        return this;
    }
}

