/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.imprt;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.ILastJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.imprt.BulkImportJobParameters;
import ca.uhn.fhir.batch2.jobs.imprt.NdJsonFileJson;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import jakarta.annotation.Nonnull;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConsumeFilesStep
implements ILastJobStepWorker<BulkImportJobParameters, NdJsonFileJson> {
    private static final Logger ourLog = LoggerFactory.getLogger(ConsumeFilesStep.class);
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private HapiTransactionService myHapiTransactionService;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private IFhirSystemDao<?, ?> mySystemDao;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<BulkImportJobParameters, NdJsonFileJson> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) {
        String ndjson = ((NdJsonFileJson)theStepExecutionDetails.getData()).getNdJsonText();
        String sourceName = ((NdJsonFileJson)theStepExecutionDetails.getData()).getSourceName();
        IParser jsonParser = this.myCtx.newJsonParser();
        LineIterator lineIter = new LineIterator((Reader)new StringReader(ndjson));
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        while (lineIter.hasNext()) {
            IBaseResource parsed;
            String next = lineIter.next();
            if (!StringUtils.isNotBlank((CharSequence)next)) continue;
            try {
                parsed = jsonParser.parseResource(next);
            }
            catch (DataFormatException e) {
                throw new JobExecutionFailedException(Msg.code((int)2052) + "Failed to parse resource: " + e, (Throwable)e);
            }
            resources.add(parsed);
        }
        ourLog.info("Bulk loading {} resources from source {}", (Object)resources.size(), (Object)sourceName);
        this.storeResources(resources, ((BulkImportJobParameters)theStepExecutionDetails.getParameters()).getPartitionId());
        return new RunOutcome(resources.size());
    }

    public void storeResources(List<IBaseResource> resources, RequestPartitionId thePartitionId) {
        SystemRequestDetails requestDetails = new SystemRequestDetails();
        if (thePartitionId == null) {
            requestDetails.setRequestPartitionId(RequestPartitionId.defaultPartition());
        } else {
            requestDetails.setRequestPartitionId(thePartitionId);
        }
        TransactionDetails transactionDetails = new TransactionDetails();
        this.myHapiTransactionService.execute((RequestDetails)requestDetails, transactionDetails, tx -> this.storeResourcesInsideTransaction(resources, requestDetails, transactionDetails));
    }

    private Void storeResourcesInsideTransaction(List<IBaseResource> theResources, SystemRequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        HashMap<IIdType, IBaseResource> ids = new HashMap<IIdType, IBaseResource>();
        for (IBaseResource next : theResources) {
            if (!next.getIdElement().hasIdPart()) continue;
            IIdType id = next.getIdElement();
            if (!id.hasResourceType()) {
                id.setParts(null, this.myCtx.getResourceType(next), id.getIdPart(), id.getVersionIdPart());
            }
            ids.put(id, next);
        }
        ArrayList idsList = new ArrayList(ids.keySet());
        List resolvedIds = this.myIdHelperService.resolveResourcePersistentIdsWithCache(theRequestDetails.getRequestPartitionId(), idsList, true);
        for (IResourcePersistentId iResourcePersistentId : resolvedIds) {
            IIdType resId = iResourcePersistentId.getAssociatedResourceId();
            theTransactionDetails.addResolvedResourceId(resId, iResourcePersistentId);
            ids.remove(resId);
        }
        for (IIdType iIdType : ids.keySet()) {
            theTransactionDetails.addResolvedResourceId(iIdType, null);
        }
        this.mySystemDao.preFetchResources(resolvedIds, true);
        for (IBaseResource iBaseResource : theResources) {
            this.updateResource((RequestDetails)theRequestDetails, theTransactionDetails, iBaseResource);
        }
        return null;
    }

    private <T extends IBaseResource> void updateResource(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, T theResource) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResource);
        try {
            dao.update(theResource, null, true, false, theRequestDetails, theTransactionDetails);
        }
        catch (InvalidRequestException | PreconditionFailedException e) {
            String msg = "Failure during bulk import: " + (BaseServerResponseException)e;
            ourLog.error(msg);
            throw new JobExecutionFailedException(Msg.code((int)2053) + msg, e);
        }
    }
}

