/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.imprt;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.imprt.BulkImportJobParameters;
import ca.uhn.fhir.batch2.jobs.imprt.NdJsonFileJson;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.client.impl.HttpBasicAuthInterceptor;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.FileUtil;
import ca.uhn.fhir.util.StopWatch;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchFilesStep
implements IFirstJobStepWorker<BulkImportJobParameters, NdJsonFileJson> {
    private static final Logger ourLog = LoggerFactory.getLogger(FetchFilesStep.class);
    private static final List<String> ourValidContentTypes = Arrays.asList("application/ndjson", "application/fhir+ndjson", "application/json+fhir", "application/fhir+json", "application/json", "text/plain");
    private static final List<String> ourValidNonNdJsonContentTypes = Arrays.asList("application/json+fhir", "application/fhir+json", "application/json", "text/plain");

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<BulkImportJobParameters, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<NdJsonFileJson> theDataSink) {
        RunOutcome runOutcome;
        block31: {
            Integer maxBatchResourceCount = ((BulkImportJobParameters)theStepExecutionDetails.getParameters()).getMaxBatchResourceCount();
            if (maxBatchResourceCount == null || maxBatchResourceCount <= 0) {
                maxBatchResourceCount = 800;
            }
            CloseableHttpClient httpClient = this.newHttpClient(theStepExecutionDetails);
            try {
                StopWatch outerSw = new StopWatch();
                List<String> urls = ((BulkImportJobParameters)theStepExecutionDetails.getParameters()).getNdJsonUrls();
                for (String nextUrl : urls) {
                    ourLog.info("Fetching URL: {}", (Object)nextUrl);
                    StopWatch urlSw = new StopWatch();
                    try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(nextUrl));){
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode >= 400) {
                            throw new JobExecutionFailedException(Msg.code((int)2056) + "Received HTTP " + statusCode + " from URL: " + nextUrl);
                        }
                        String contentType = response.getEntity().getContentType().getValue();
                        Validate.isTrue((boolean)FetchFilesStep.hasMatchingSubstring(contentType, ourValidContentTypes), (String)"Received content type \"%s\" from URL: %s. This format is not one of the supported content type: %s", (Object[])new Object[]{contentType, nextUrl, FetchFilesStep.getContentTypesString()});
                        if (FetchFilesStep.hasMatchingSubstring(contentType, ourValidNonNdJsonContentTypes)) {
                            ourLog.info("Received non-NDJSON content type \"{}\" from URL: {}. It will be processed but it may not complete correctly if the actual data is not NDJSON.", (Object)contentType, (Object)nextUrl);
                        }
                        try (InputStream inputStream = response.getEntity().getContent();
                             LineIterator lineIterator = new LineIterator((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                            int chunkCount = 0;
                            int lineCount = 0;
                            StringBuilder builder = new StringBuilder();
                            while (lineIterator.hasNext()) {
                                String nextLine = lineIterator.nextLine();
                                builder.append(nextLine).append('\n');
                                int charCount = builder.length();
                                int batchSizeChars = 0x1400000;
                                if (++lineCount < maxBatchResourceCount && charCount < batchSizeChars && lineIterator.hasNext()) continue;
                                ourLog.info("Loaded chunk {} of {} NDJSON file with {} resources from URL: {}", new Object[]{chunkCount, FileUtil.formatFileSize((long)charCount), lineCount, nextUrl});
                                NdJsonFileJson data = new NdJsonFileJson();
                                data.setNdJsonText(builder.toString());
                                data.setSourceName(nextUrl);
                                theDataSink.accept((IModelJson)data);
                                builder.setLength(0);
                                lineCount = 0;
                                ++chunkCount;
                            }
                        }
                    }
                    ourLog.info("Loaded and processed URL in {}", (Object)urlSw);
                }
                ourLog.info("Loaded and processed {} URLs in {}", (Object)urls.size(), (Object)outerSw);
                runOutcome = new RunOutcome(0);
                if (httpClient == null) break block31;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalErrorException(Msg.code((int)2054) + e.getMessage(), (Throwable)e);
                }
            }
            httpClient.close();
        }
        return runOutcome;
    }

    private CloseableHttpClient newHttpClient(StepExecutionDetails<BulkImportJobParameters, ?> theStepExecutionDetails) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        String httpBasicCredentials = ((BulkImportJobParameters)theStepExecutionDetails.getParameters()).getHttpBasicCredentials();
        if (StringUtils.isNotBlank((CharSequence)httpBasicCredentials)) {
            int colonIdx = httpBasicCredentials.indexOf(58);
            if (colonIdx == -1) {
                throw new JobExecutionFailedException(Msg.code((int)2055) + "Invalid credential parameter provided. Must be in the form \"username:password\".");
            }
            String username = httpBasicCredentials.substring(0, colonIdx);
            String password = httpBasicCredentials.substring(colonIdx + 1);
            builder.addInterceptorFirst((HttpRequestInterceptor)new HttpBasicAuthInterceptor(username, password));
        }
        return builder.build();
    }

    private static boolean hasMatchingSubstring(String str, List<String> substrings) {
        return substrings.stream().anyMatch(str::contains);
    }

    private static String getContentTypesString() {
        return String.join((CharSequence)", ", ourValidContentTypes);
    }
}

