/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.imprt;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.util.StopWatch;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceOrderUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceOrderUtil.class);

    private ResourceOrderUtil() {
    }

    public static List<String> getResourceOrder(FhirContext theFhirContext) {
        int passCount;
        ArrayList<String> retVal = new ArrayList<String>(theFhirContext.getResourceTypes());
        HashSet<CallSite> moves = new HashSet<CallSite>();
        StopWatch sw = new StopWatch();
        for (passCount = 0; passCount < retVal.size(); ++passCount) {
            ourLog.debug("Starting passCount {}", (Object)passCount);
            int changeCount = 0;
            for (int i = retVal.size() - 1; i >= 0; --i) {
                String typeAtCurrentIndex = retVal.get(i);
                RuntimeResourceDefinition typeDefinition = theFhirContext.getResourceDefinition(typeAtCurrentIndex);
                List params = typeDefinition.getSearchParams().stream().filter(t -> t.getParamType() == RestSearchParameterTypeEnum.REFERENCE).collect(Collectors.toList());
                block2: for (RuntimeSearchParam nextParam : params) {
                    for (String targetType : nextParam.getTargets()) {
                        String nextParamName;
                        String key;
                        int targetIndex = retVal.indexOf(targetType);
                        if (targetIndex <= i || !moves.add((CallSite)((Object)(key = typeAtCurrentIndex + " " + (nextParamName = nextParam.getName()) + " " + targetType + " " + i + " " + targetIndex)))) continue;
                        ourLog.debug("Resource[{}] at index[{}] has SP[{}] with target[{}] at index[{}] - moving to index[{}]", new Object[]{typeAtCurrentIndex, i, nextParamName, targetType, targetIndex, i});
                        retVal.set(targetIndex, typeAtCurrentIndex);
                        retVal.set(i, targetType);
                        i = targetIndex;
                        ++changeCount;
                        continue block2;
                    }
                }
            }
            ourLog.debug("Finished pass {} with {} changes", (Object)passCount, (Object)changeCount);
            if (changeCount == 0) break;
        }
        ourLog.info("Calculated optimal resource order in {} passes in {}", (Object)passCount, (Object)sw);
        return retVal;
    }
}

