/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.models;

import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BatchResourceId
implements IModelJson,
Comparable<BatchResourceId> {
    @JsonProperty(value="type")
    private String myResourceType;
    @JsonProperty(value="id")
    private String myId;

    public String toString() {
        return "[" + this.myResourceType + " " + this.myId + "]";
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public BatchResourceId setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
        return this;
    }

    public String getId() {
        return this.myId;
    }

    public BatchResourceId setId(String theId) {
        this.myId = theId;
        return this;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        BatchResourceId batchResourceId = (BatchResourceId)theO;
        return new EqualsBuilder().append((Object)this.myResourceType, (Object)batchResourceId.myResourceType).append((Object)this.myId, (Object)batchResourceId.myId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myResourceType).append((Object)this.myId).toHashCode();
    }

    public int estimateSerializedSize() {
        return 19 + StringUtils.defaultString((String)this.myId).length() + StringUtils.defaultString((String)this.myResourceType).length();
    }

    @Override
    public int compareTo(@Nonnull BatchResourceId o) {
        int retVal = o.myResourceType.compareTo(this.myResourceType);
        if (retVal == 0) {
            retVal = o.myId.compareTo(this.myId);
        }
        return retVal;
    }

    public static BatchResourceId getIdFromPID(IResourcePersistentId thePID, String theResourceType) {
        BatchResourceId batchResourceId = new BatchResourceId();
        batchResourceId.setId(thePID.getId().toString());
        batchResourceId.setResourceType(theResourceType);
        return batchResourceId;
    }
}

