/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.reindex;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobPartitionProvider;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.ChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.parameters.IUrlListValidator;
import ca.uhn.fhir.batch2.jobs.parameters.UrlListValidator;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexJobParameters;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexJobParametersValidator;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexProvider;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexStep;
import ca.uhn.fhir.batch2.jobs.step.GenerateRangeChunksStep;
import ca.uhn.fhir.batch2.jobs.step.LoadIdsStep;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ReindexAppCtx {
    public static final String JOB_REINDEX = "REINDEX";

    @Bean
    public JobDefinition<ReindexJobParameters> reindexJobDefinition(IBatch2DaoSvc theBatch2DaoSvc) {
        return JobDefinition.newBuilder().setJobDefinitionId(JOB_REINDEX).setJobDescription("Reindex resources").setJobDefinitionVersion(1).setParametersType(ReindexJobParameters.class).setParametersValidator((IJobParametersValidator)this.reindexJobParametersValidator(theBatch2DaoSvc)).gatedExecution().addFirstStep("generate-ranges", "Generate data ranges to reindex", ChunkRangeJson.class, this.reindexGenerateRangeChunksStep()).addIntermediateStep("load-ids", "Load IDs of resources to reindex", ResourceIdListWorkChunkJson.class, this.reindexLoadIdsStep(theBatch2DaoSvc)).addLastStep("reindex", "Perform the resource reindex", (IJobStepWorker)this.reindexStep()).build();
    }

    @Bean
    public IJobStepWorker<ReindexJobParameters, VoidModel, ChunkRangeJson> reindexGenerateRangeChunksStep() {
        return new GenerateRangeChunksStep();
    }

    @Bean
    public IJobStepWorker<ReindexJobParameters, ChunkRangeJson, ResourceIdListWorkChunkJson> reindexLoadIdsStep(IBatch2DaoSvc theBatch2DaoSvc) {
        return new LoadIdsStep(theBatch2DaoSvc);
    }

    @Bean
    public ReindexJobParametersValidator reindexJobParametersValidator(IBatch2DaoSvc theBatch2DaoSvc) {
        return new ReindexJobParametersValidator((IUrlListValidator)new UrlListValidator("$reindex", theBatch2DaoSvc));
    }

    @Bean
    public ReindexStep reindexStep() {
        return new ReindexStep();
    }

    @Bean
    public ReindexProvider reindexProvider(FhirContext theFhirContext, IJobCoordinator theJobCoordinator, IJobPartitionProvider theJobPartitionHandler) {
        return new ReindexProvider(theFhirContext, theJobCoordinator, theJobPartitionHandler);
    }
}

