/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.reindex;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.jobs.parameters.IUrlListValidator;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexJobParameters;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public class ReindexJobParametersValidator
implements IJobParametersValidator<ReindexJobParameters> {
    private final IUrlListValidator myUrlListValidator;

    public ReindexJobParametersValidator(IUrlListValidator theUrlListValidator) {
        this.myUrlListValidator = theUrlListValidator;
    }

    @Nullable
    public List<String> validate(RequestDetails theRequestDetails, @Nonnull ReindexJobParameters theParameters) {
        ArrayList<String> errors = this.myUrlListValidator.validateUrls(theParameters.getUrls());
        if (errors == null || errors.isEmpty()) {
            errors = new ArrayList<String>();
            for (String url : theParameters.getUrls()) {
                if (!url.contains(" ") && !url.contains("\n") && !url.contains("\t")) continue;
                errors.add("Invalid URL. URL cannot contain spaces : " + url);
            }
        }
        return errors;
    }
}

