/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.reindex;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.api.IJobPartitionProvider;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexJobParameters;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.ReindexParameters;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.base.Ascii;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ReindexProvider {
    private final FhirContext myFhirContext;
    private final IJobCoordinator myJobCoordinator;
    private final IJobPartitionProvider myJobPartitionProvider;

    public ReindexProvider(FhirContext theFhirContext, IJobCoordinator theJobCoordinator, IJobPartitionProvider theJobPartitionProvider) {
        this.myFhirContext = theFhirContext;
        this.myJobCoordinator = theJobCoordinator;
        this.myJobPartitionProvider = theJobPartitionProvider;
    }

    @Operation(name="$reindex", idempotent=false)
    public IBaseParameters reindex(@Description(value="Optionally provides one ore more relative search parameter URLs (e.g. \"Patient?active=true\" or \"Observation?\") that will be reindexed. Note that the URL applies to the resources as they are currently indexed, so you should not use a search parameter that needs reindexing in the URL or some resources may be missed. If no URLs are provided, all resources of all types will be reindexed.") @OperationParam(name="url", typeName="string", min=0, max=-1) List<IPrimitiveType<String>> theUrlsToReindex, @Description(value="Should search parameters be reindexed (default: ALL)") @OperationParam(name="reindexSearchParameters", typeName="code", min=0, max=1) IPrimitiveType<String> theReindexSearchParameters, @Description(value="Should we attempt to optimize storage for resources (default: NONE)") @OperationParam(name="optimizeStorage", typeName="code", min=0, max=1) IPrimitiveType<String> theOptimizeStorage, @Description(value="Should we attempt to optimistically lock resources being reindexed in order to avoid concurrency issues (default: true)") @OperationParam(name="optimisticLock", typeName="boolean", min=0, max=1) IPrimitiveType<Boolean> theOptimisticLock, RequestDetails theRequestDetails) {
        String value;
        ReindexJobParameters params = new ReindexJobParameters();
        if (theReindexSearchParameters != null && (value = (String)theReindexSearchParameters.getValue()) != null) {
            value = Ascii.toUpperCase((String)value);
            ValidateUtil.isTrueOrThrowInvalidRequest((boolean)EnumUtils.isValidEnum(ReindexParameters.ReindexSearchParametersEnum.class, (String)value), (String)("Invalid reindexSearchParameters value: " + UrlUtil.sanitizeUrlPart((CharSequence)((CharSequence)theReindexSearchParameters.getValue()))), (Object[])new Object[0]);
            params.setReindexSearchParameters(ReindexParameters.ReindexSearchParametersEnum.valueOf((String)value));
        }
        if (theOptimizeStorage != null && (value = (String)theOptimizeStorage.getValue()) != null) {
            value = Ascii.toUpperCase((String)value);
            ValidateUtil.isTrueOrThrowInvalidRequest((boolean)EnumUtils.isValidEnum(ReindexParameters.OptimizeStorageModeEnum.class, (String)value), (String)("Invalid optimizeStorage value: " + UrlUtil.sanitizeUrlPart((CharSequence)((CharSequence)theOptimizeStorage.getValue()))), (Object[])new Object[0]);
            params.setOptimizeStorage(ReindexParameters.OptimizeStorageModeEnum.valueOf((String)value));
        }
        if (theOptimisticLock != null && theOptimisticLock.getValue() != null) {
            params.setOptimisticLock((Boolean)theOptimisticLock.getValue());
        }
        List<Object> urls = List.of();
        if (theUrlsToReindex != null) {
            urls = theUrlsToReindex.stream().map(IPrimitiveType::getValue).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        this.myJobPartitionProvider.getPartitionedUrls(theRequestDetails, urls).forEach(arg_0 -> ((ReindexJobParameters)params).addPartitionedUrl(arg_0));
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setJobDefinitionId("REINDEX");
        request.setParameters((IModelJson)params);
        Batch2JobStartResponse response = this.myJobCoordinator.startInstance(theRequestDetails, request);
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myFhirContext, (IBaseParameters)retVal, (String)"jobId", (String)response.getInstanceId());
        return retVal;
    }
}

