/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.reindex;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.IWarningProcessor;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexJobParameters;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexWarningProcessor;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.dao.ReindexOutcome;
import ca.uhn.fhir.jpa.api.dao.ReindexParameters;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.StopWatch;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class ReindexStep
implements IJobStepWorker<ReindexJobParameters, ResourceIdListWorkChunkJson, VoidModel> {
    public static final int REINDEX_MAX_RETRIES = 10;
    private static final Logger ourLog = LoggerFactory.getLogger(ReindexStep.class);
    @Autowired
    private HapiTransactionService myHapiTransactionService;
    @Autowired
    private IFhirSystemDao<?, ?> mySystemDao;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IIdHelperService<IResourcePersistentId> myIdHelperService;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<ReindexJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        ResourceIdListWorkChunkJson data = (ResourceIdListWorkChunkJson)theStepExecutionDetails.getData();
        ReindexJobParameters jobParameters = (ReindexJobParameters)theStepExecutionDetails.getParameters();
        return this.doReindex(data, theDataSink, theStepExecutionDetails.getInstance().getInstanceId(), theStepExecutionDetails.getChunkId(), jobParameters);
    }

    @Nonnull
    public RunOutcome doReindex(ResourceIdListWorkChunkJson data, IJobDataSink<VoidModel> theDataSink, String theInstanceId, String theChunkId, ReindexJobParameters theJobParameters) {
        SystemRequestDetails requestDetails = new SystemRequestDetails();
        requestDetails.setRetry(true);
        requestDetails.setMaxRetries(10);
        TransactionDetails transactionDetails = new TransactionDetails();
        ReindexJob reindexJob = new ReindexJob(data, (RequestDetails)requestDetails, transactionDetails, theDataSink, theInstanceId, theChunkId, theJobParameters);
        this.myHapiTransactionService.withRequest((RequestDetails)requestDetails).withTransactionDetails(transactionDetails).withRequestPartitionId(data.getRequestPartitionId()).execute((TransactionCallback)reindexJob);
        return new RunOutcome(data.size());
    }

    private class ReindexJob
    implements TransactionCallback<Void> {
        private final ResourceIdListWorkChunkJson myData;
        private final RequestDetails myRequestDetails;
        private final TransactionDetails myTransactionDetails;
        private final IJobDataSink<VoidModel> myDataSink;
        private final String myChunkId;
        private final String myInstanceId;
        private final ReindexJobParameters myJobParameters;

        public ReindexJob(ResourceIdListWorkChunkJson theData, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, IJobDataSink<VoidModel> theDataSink, String theInstanceId, String theChunkId, ReindexJobParameters theJobParameters) {
            this.myData = theData;
            this.myRequestDetails = theRequestDetails;
            this.myTransactionDetails = theTransactionDetails;
            this.myDataSink = theDataSink;
            this.myInstanceId = theInstanceId;
            this.myChunkId = theChunkId;
            this.myJobParameters = theJobParameters;
            this.myDataSink.setWarningProcessor((IWarningProcessor)new ReindexWarningProcessor());
        }

        public Void doInTransaction(@Nonnull TransactionStatus theStatus) {
            List persistentIds = this.myData.getResourcePersistentIds(ReindexStep.this.myIdHelperService);
            ourLog.info("Starting reindex work chunk with {} resources - Instance[{}] Chunk[{}]", new Object[]{persistentIds.size(), this.myInstanceId, this.myChunkId});
            StopWatch sw = new StopWatch();
            boolean reindexSearchParameters = this.myJobParameters.getReindexSearchParameters() != ReindexParameters.ReindexSearchParametersEnum.NONE;
            ReindexStep.this.mySystemDao.preFetchResources(persistentIds, reindexSearchParameters);
            ourLog.info("Prefetched {} resources in {} - Instance[{}] Chunk[{}]", new Object[]{persistentIds.size(), sw, this.myInstanceId, this.myChunkId});
            ReindexParameters parameters = new ReindexParameters().setReindexSearchParameters(this.myJobParameters.getReindexSearchParameters()).setOptimizeStorage(this.myJobParameters.getOptimizeStorage()).setOptimisticLock(this.myJobParameters.getOptimisticLock());
            sw.restart();
            for (int i = 0; i < this.myData.size(); ++i) {
                String nextResourceType = this.myData.getResourceType(i);
                IFhirResourceDao dao = ReindexStep.this.myDaoRegistry.getResourceDao(nextResourceType);
                IResourcePersistentId resourcePersistentId = (IResourcePersistentId)persistentIds.get(i);
                try {
                    ReindexOutcome outcome = dao.reindex(resourcePersistentId, parameters, this.myRequestDetails, this.myTransactionDetails);
                    outcome.getWarnings().forEach(arg_0 -> this.myDataSink.recoveredError(arg_0));
                    continue;
                }
                catch (DataFormatException | BaseServerResponseException e) {
                    String resourceForcedId = ReindexStep.this.myIdHelperService.translatePidIdToForcedIdWithCache(resourcePersistentId).orElse(resourcePersistentId.toString());
                    String resourceId = nextResourceType + "/" + resourceForcedId;
                    ourLog.debug("Failure during reindexing {}", (Object)resourceId, (Object)e);
                    this.myDataSink.recoveredError("Failure reindexing " + resourceId + ": " + e.getMessage());
                }
            }
            ourLog.info("Finished reindexing {} resources in {} - {}/sec - Instance[{}] Chunk[{}]", new Object[]{persistentIds.size(), sw, sw.formatThroughput((long)persistentIds.size(), TimeUnit.SECONDS), this.myInstanceId, this.myChunkId});
            return null;
        }
    }
}

