/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.termcodesystem;

import ca.uhn.fhir.batch2.api.IJobCompletionHandler;
import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.IReductionStepWorker;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete.DeleteCodeSystemCompletionHandler;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete.DeleteCodeSystemConceptsByVersionStep;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete.DeleteCodeSystemStep;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete.DeleteCodeSystemVersionStep;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete.ReadTermConceptVersionsStep;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete.TermCodeSystemDeleteJobParametersValidator;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemversiondelete.DeleteCodeSystemVersionCompletionHandler;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemversiondelete.DeleteCodeSystemVersionFinalStep;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemversiondelete.DeleteCodeSystemVersionFirstStep;
import ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemversiondelete.DeleteCodeSystemVersionParameterValidator;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemDeleteJobSvc;
import ca.uhn.fhir.jpa.term.models.CodeSystemVersionPIDResult;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteJobParameters;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteVersionJobParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TermCodeSystemJobConfig {
    public static final String TERM_CODE_SYSTEM_DELETE_JOB_NAME = "termCodeSystemDeleteJob";
    public static final String TERM_CODE_SYSTEM_VERSION_DELETE_JOB_NAME = "termCodeSystemVersionDeleteJob";
    @Autowired
    private ITermCodeSystemDeleteJobSvc myITermCodeSystemSvc;

    @Bean
    public JobDefinition<TermCodeSystemDeleteVersionJobParameters> termCodeSystemVersionDeleteJobDefinition() {
        return JobDefinition.newBuilder().setJobDefinitionId(TERM_CODE_SYSTEM_VERSION_DELETE_JOB_NAME).setJobDescription("Term code system version job delete").setJobDefinitionVersion(1).gatedExecution().setParametersType(TermCodeSystemDeleteVersionJobParameters.class).setParametersValidator((IJobParametersValidator)this.deleteCodeSystemVersionPrameterValidator()).addFirstStep("DeleteCodeSystemVersionFirstStep", "A first step for deleting code system versions; deletes the concepts for a provided code system version", CodeSystemVersionPIDResult.class, (IJobStepWorker)this.deleteCodeSystemVersionFirstStep()).addLastStep("DeleteCodeSystemVersionFinalStep", "Deletes the code system version", (IJobStepWorker)this.deleteCodeSystemVersionFinalStep()).completionHandler((IJobCompletionHandler)this.deleteCodeSystemVersionCompletionHandler()).errorHandler((IJobCompletionHandler)this.deleteCodeSystemVersionCompletionHandler()).build();
    }

    @Bean
    public JobDefinition<TermCodeSystemDeleteJobParameters> termCodeSystemDeleteJobDefinition() {
        return JobDefinition.newBuilder().setJobDefinitionId(TERM_CODE_SYSTEM_DELETE_JOB_NAME).setJobDescription("Term code system job delete").setJobDefinitionVersion(1).gatedExecution().setParametersType(TermCodeSystemDeleteJobParameters.class).setParametersValidator((IJobParametersValidator)this.codeSystemDeleteParameterValidator()).addFirstStep("FetchVersionsStep", "Fetches all term code system version PIDs for given Code System PID", CodeSystemVersionPIDResult.class, (IJobStepWorker)this.readCodeSystemVersionsStep()).addIntermediateStep("DeleteCodeSystemConceptsByVersionPidStep", "Deletes the concept links, concept properties, concept designations, and concepts associated with a given code system version PID", CodeSystemVersionPIDResult.class, (IJobStepWorker)this.deleteCodeSystemConceptsStep()).addIntermediateStep("DeleteCodeSystemVersionStep", "Deletes the specified code system version", CodeSystemVersionPIDResult.class, (IJobStepWorker)this.deleteCodeSystemVersionsStep()).addFinalReducerStep("DeleteCodeSystemStep", "Deletes the code system itself", VoidModel.class, (IReductionStepWorker)this.deleteCodeSystemFinalStep()).completionHandler((IJobCompletionHandler)this.deleteCodeSystemCompletionHandler()).errorHandler((IJobCompletionHandler)this.deleteCodeSystemCompletionHandler()).build();
    }

    @Bean
    public TermCodeSystemDeleteJobParametersValidator codeSystemDeleteParameterValidator() {
        return new TermCodeSystemDeleteJobParametersValidator();
    }

    @Bean
    public ReadTermConceptVersionsStep readCodeSystemVersionsStep() {
        return new ReadTermConceptVersionsStep(this.myITermCodeSystemSvc);
    }

    @Bean
    public DeleteCodeSystemConceptsByVersionStep deleteCodeSystemConceptsStep() {
        return new DeleteCodeSystemConceptsByVersionStep(this.myITermCodeSystemSvc);
    }

    @Bean
    public DeleteCodeSystemVersionStep deleteCodeSystemVersionsStep() {
        return new DeleteCodeSystemVersionStep(this.myITermCodeSystemSvc);
    }

    @Bean
    public DeleteCodeSystemStep deleteCodeSystemFinalStep() {
        return new DeleteCodeSystemStep(this.myITermCodeSystemSvc);
    }

    @Bean
    public DeleteCodeSystemCompletionHandler deleteCodeSystemCompletionHandler() {
        return new DeleteCodeSystemCompletionHandler(this.myITermCodeSystemSvc);
    }

    @Bean
    public DeleteCodeSystemVersionParameterValidator deleteCodeSystemVersionPrameterValidator() {
        return new DeleteCodeSystemVersionParameterValidator();
    }

    @Bean
    public DeleteCodeSystemVersionFirstStep deleteCodeSystemVersionFirstStep() {
        return new DeleteCodeSystemVersionFirstStep(this.myITermCodeSystemSvc);
    }

    @Bean
    public DeleteCodeSystemVersionFinalStep deleteCodeSystemVersionFinalStep() {
        return new DeleteCodeSystemVersionFinalStep(this.myITermCodeSystemSvc);
    }

    @Bean
    public DeleteCodeSystemVersionCompletionHandler deleteCodeSystemVersionCompletionHandler() {
        return new DeleteCodeSystemVersionCompletionHandler(this.myITermCodeSystemSvc);
    }
}

