/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete;

import ca.uhn.fhir.batch2.api.ChunkExecutionDetails;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IReductionStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.model.ChunkOutcome;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemDeleteJobSvc;
import ca.uhn.fhir.jpa.term.models.CodeSystemVersionPIDResult;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteJobParameters;
import ca.uhn.fhir.model.api.IModelJson;
import jakarta.annotation.Nonnull;

public class DeleteCodeSystemStep
implements IReductionStepWorker<TermCodeSystemDeleteJobParameters, CodeSystemVersionPIDResult, VoidModel> {
    private final ITermCodeSystemDeleteJobSvc myITermCodeSystemSvc;

    public DeleteCodeSystemStep(ITermCodeSystemDeleteJobSvc theCodeSystemDeleteJobSvc) {
        this.myITermCodeSystemSvc = theCodeSystemDeleteJobSvc;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<TermCodeSystemDeleteJobParameters, CodeSystemVersionPIDResult> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        long codeId = ((TermCodeSystemDeleteJobParameters)theStepExecutionDetails.getParameters()).getTermPid();
        this.myITermCodeSystemSvc.deleteCodeSystem(codeId);
        theDataSink.accept((IModelJson)new VoidModel());
        return RunOutcome.SUCCESS;
    }

    @Nonnull
    public ChunkOutcome consume(ChunkExecutionDetails<TermCodeSystemDeleteJobParameters, CodeSystemVersionPIDResult> theChunkDetails) {
        return ChunkOutcome.SUCCESS();
    }
}

