/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemDeleteJobSvc;
import ca.uhn.fhir.jpa.term.models.CodeSystemVersionPIDResult;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteJobParameters;
import ca.uhn.fhir.model.api.IModelJson;
import jakarta.annotation.Nonnull;

public class DeleteCodeSystemVersionStep
implements IJobStepWorker<TermCodeSystemDeleteJobParameters, CodeSystemVersionPIDResult, CodeSystemVersionPIDResult> {
    private final ITermCodeSystemDeleteJobSvc myITermCodeSystemSvc;

    public DeleteCodeSystemVersionStep(ITermCodeSystemDeleteJobSvc theCodeSystemDeleteJobSvc) {
        this.myITermCodeSystemSvc = theCodeSystemDeleteJobSvc;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<TermCodeSystemDeleteJobParameters, CodeSystemVersionPIDResult> theStepExecutionDetails, @Nonnull IJobDataSink<CodeSystemVersionPIDResult> theDataSink) throws JobExecutionFailedException {
        CodeSystemVersionPIDResult versionPidResult = (CodeSystemVersionPIDResult)theStepExecutionDetails.getData();
        long versionId = versionPidResult.getCodeSystemVersionPID();
        this.myITermCodeSystemSvc.deleteCodeSystemVersion(versionId);
        theDataSink.accept((IModelJson)versionPidResult);
        return RunOutcome.SUCCESS;
    }
}

