/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemdelete;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemDeleteJobSvc;
import ca.uhn.fhir.jpa.term.models.CodeSystemVersionPIDResult;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteJobParameters;
import ca.uhn.fhir.model.api.IModelJson;
import jakarta.annotation.Nonnull;
import java.util.Iterator;

public class ReadTermConceptVersionsStep
implements IFirstJobStepWorker<TermCodeSystemDeleteJobParameters, CodeSystemVersionPIDResult> {
    private final ITermCodeSystemDeleteJobSvc myITermCodeSystemSvc;

    public ReadTermConceptVersionsStep(ITermCodeSystemDeleteJobSvc theCodeSystemDeleteJobSvc) {
        this.myITermCodeSystemSvc = theCodeSystemDeleteJobSvc;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<TermCodeSystemDeleteJobParameters, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<CodeSystemVersionPIDResult> theDataSink) throws JobExecutionFailedException {
        TermCodeSystemDeleteJobParameters parameters = (TermCodeSystemDeleteJobParameters)theStepExecutionDetails.getParameters();
        long pid = parameters.getTermPid();
        Iterator versionPids = this.myITermCodeSystemSvc.getAllCodeSystemVersionForCodeSystemPid(pid);
        while (versionPids.hasNext()) {
            long next = (Long)versionPids.next();
            CodeSystemVersionPIDResult versionPidResult = new CodeSystemVersionPIDResult();
            versionPidResult.setCodeSystemVersionPID(next);
            theDataSink.accept((IModelJson)versionPidResult);
        }
        return RunOutcome.SUCCESS;
    }
}

