/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemversiondelete;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.ILastJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemDeleteJobSvc;
import ca.uhn.fhir.jpa.term.models.CodeSystemVersionPIDResult;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteVersionJobParameters;
import jakarta.annotation.Nonnull;

public class DeleteCodeSystemVersionFinalStep
implements ILastJobStepWorker<TermCodeSystemDeleteVersionJobParameters, CodeSystemVersionPIDResult> {
    private final ITermCodeSystemDeleteJobSvc myTermCodeSystemSvc;

    public DeleteCodeSystemVersionFinalStep(ITermCodeSystemDeleteJobSvc theCodeSystemDeleteJobSvc) {
        this.myTermCodeSystemSvc = theCodeSystemDeleteJobSvc;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<TermCodeSystemDeleteVersionJobParameters, CodeSystemVersionPIDResult> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        long versionPid = ((TermCodeSystemDeleteVersionJobParameters)theStepExecutionDetails.getParameters()).getCodeSystemVersionPid();
        this.myTermCodeSystemSvc.deleteCodeSystemVersion(versionPid);
        return RunOutcome.SUCCESS;
    }
}

