/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.termcodesystem.codesystemversiondelete;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemDeleteJobSvc;
import ca.uhn.fhir.jpa.term.models.CodeSystemVersionPIDResult;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteVersionJobParameters;
import ca.uhn.fhir.model.api.IModelJson;
import jakarta.annotation.Nonnull;

public class DeleteCodeSystemVersionFirstStep
implements IFirstJobStepWorker<TermCodeSystemDeleteVersionJobParameters, CodeSystemVersionPIDResult> {
    private final ITermCodeSystemDeleteJobSvc myTermCodeSystemSvc;

    public DeleteCodeSystemVersionFirstStep(ITermCodeSystemDeleteJobSvc theCodeSystemDeleteJobSvc) {
        this.myTermCodeSystemSvc = theCodeSystemDeleteJobSvc;
    }

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<TermCodeSystemDeleteVersionJobParameters, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<CodeSystemVersionPIDResult> theDataSink) throws JobExecutionFailedException {
        long versionId = ((TermCodeSystemDeleteVersionJobParameters)theStepExecutionDetails.getParameters()).getCodeSystemVersionPid();
        this.myTermCodeSystemSvc.deleteCodeSystemConceptsByCodeSystemVersionPid(versionId);
        CodeSystemVersionPIDResult result = new CodeSystemVersionPIDResult();
        result.setCodeSystemVersionPID(versionId);
        theDataSink.accept((IModelJson)result);
        return RunOutcome.SUCCESS;
    }
}

