/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.api;

import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.coordinator.BatchWorkChunk;
import ca.uhn.fhir.batch2.model.FetchJobInstancesRequest;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.MarkWorkChunkAsErrorRequest;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import ca.uhn.fhir.i18n.Msg;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface IJobPersistence {
    public String storeWorkChunk(BatchWorkChunk var1);

    public Optional<WorkChunk> fetchWorkChunkSetStartTimeAndMarkInProgress(String var1);

    public String storeNewInstance(JobInstance var1);

    public Optional<JobInstance> fetchInstance(String var1);

    default public List<JobInstance> fetchInstances(String theJobDefinitionId, Set<StatusEnum> theStatuses, Date theCutoff, Pageable thePageable) {
        throw new UnsupportedOperationException(Msg.code((int)2271) + "Unsupported operation in this implementation");
    }

    public List<JobInstance> fetchInstances(FetchJobInstancesRequest var1, int var2, int var3);

    public List<JobInstance> fetchInstances(int var1, int var2);

    public List<JobInstance> fetchRecentInstances(int var1, int var2);

    public List<JobInstance> fetchInstancesByJobDefinitionIdAndStatus(String var1, Set<StatusEnum> var2, int var3, int var4);

    public List<JobInstance> fetchInstancesByJobDefinitionId(String var1, int var2, int var3);

    default public Page<JobInstance> fetchJobInstances(JobInstanceFetchRequest theRequest) {
        return Page.empty();
    }

    @Deprecated
    public void markWorkChunkAsErroredAndIncrementErrorCount(String var1, String var2);

    default public Optional<WorkChunk> markWorkChunkAsErroredAndIncrementErrorCount(MarkWorkChunkAsErrorRequest theParameters) {
        this.markWorkChunkAsErroredAndIncrementErrorCount(theParameters.getChunkId(), theParameters.getErrorMsg());
        return Optional.empty();
    }

    public void markWorkChunkAsFailed(String var1, String var2);

    public void markWorkChunkAsCompletedAndClearData(String var1, int var2);

    public void markWorkChunksWithStatusAndWipeData(String var1, List<String> var2, StatusEnum var3, String var4);

    public void incrementWorkChunkErrorCount(String var1, int var2);

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean canAdvanceInstanceToNextStep(String var1, String var2);

    public List<WorkChunk> fetchWorkChunksWithoutData(String var1, int var2, int var3);

    public Iterator<WorkChunk> fetchAllWorkChunksIterator(String var1, boolean var2);

    @Deprecated
    public Iterator<WorkChunk> fetchAllWorkChunksForStepIterator(String var1, String var2);

    public Stream<WorkChunk> fetchAllWorkChunksForStepStream(String var1, String var2);

    public boolean updateInstance(JobInstance var1);

    public void deleteInstanceAndChunks(String var1);

    public void deleteChunks(String var1);

    public boolean markInstanceAsCompleted(String var1);

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean markInstanceAsStatus(String var1, StatusEnum var2);

    public JobOperationResultJson cancelInstance(String var1);

    public List<String> fetchallchunkidsforstepWithStatus(String var1, String var2, StatusEnum var3);
}

