/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.channel;

import ca.uhn.fhir.batch2.model.JobWorkNotification;
import ca.uhn.fhir.batch2.model.JobWorkNotificationJsonMessage;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class BatchJobSender {
    private static final Logger ourLog = LoggerFactory.getLogger(BatchJobSender.class);
    private final IChannelProducer myWorkChannelProducer;

    public BatchJobSender(@Nonnull IChannelProducer theWorkChannelProducer) {
        this.myWorkChannelProducer = theWorkChannelProducer;
    }

    public void sendWorkChannelMessage(JobWorkNotification theJobWorkNotification) {
        JobWorkNotificationJsonMessage message = new JobWorkNotificationJsonMessage();
        message.setPayload(theJobWorkNotification);
        ourLog.info("Sending work notification for {}", (Object)theJobWorkNotification);
        this.myWorkChannelProducer.send((Message)message);
    }
}

