/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.config;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.api.IJobMaintenanceService;
import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.channel.BatchJobSender;
import ca.uhn.fhir.batch2.config.Batch2JobRegisterer;
import ca.uhn.fhir.batch2.coordinator.JobCoordinatorImpl;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.coordinator.WorkChunkProcessor;
import ca.uhn.fhir.batch2.maintenance.JobMaintenanceServiceImpl;
import ca.uhn.fhir.batch2.model.JobWorkNotificationJsonMessage;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelProducerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public abstract class BaseBatch2Config {
    public static final String CHANNEL_NAME = "batch2-work-notification";
    @Autowired
    private IJobPersistence myPersistence;
    @Autowired
    private IChannelFactory myChannelFactory;

    @Bean
    public JobDefinitionRegistry batch2JobDefinitionRegistry() {
        return new JobDefinitionRegistry();
    }

    @Bean
    public WorkChunkProcessor jobStepExecutorService(BatchJobSender theBatchJobSender, PlatformTransactionManager theTransactionManager) {
        return new WorkChunkProcessor(this.myPersistence, theBatchJobSender, theTransactionManager);
    }

    @Bean
    public BatchJobSender batchJobSender() {
        return new BatchJobSender(this.batch2ProcessingChannelProducer(this.myChannelFactory));
    }

    @Bean
    public IJobCoordinator batch2JobCoordinator(JobDefinitionRegistry theJobDefinitionRegistry, BatchJobSender theBatchJobSender, WorkChunkProcessor theExecutor, IJobMaintenanceService theJobMaintenanceService) {
        return new JobCoordinatorImpl(theBatchJobSender, this.batch2ProcessingChannelReceiver(this.myChannelFactory), this.myPersistence, theJobDefinitionRegistry, theExecutor, theJobMaintenanceService);
    }

    @Bean
    public IJobMaintenanceService batch2JobMaintenanceService(ISchedulerService theSchedulerService, JobDefinitionRegistry theJobDefinitionRegistry, DaoConfig theDaoConfig, BatchJobSender theBatchJobSender, WorkChunkProcessor theExecutor) {
        return new JobMaintenanceServiceImpl(theSchedulerService, this.myPersistence, theDaoConfig, theJobDefinitionRegistry, theBatchJobSender, theExecutor);
    }

    @Bean
    public IChannelProducer batch2ProcessingChannelProducer(IChannelFactory theChannelFactory) {
        ChannelProducerSettings settings = new ChannelProducerSettings().setConcurrentConsumers(this.getConcurrentConsumers());
        return theChannelFactory.getOrCreateProducer(CHANNEL_NAME, JobWorkNotificationJsonMessage.class, settings);
    }

    @Bean
    public IChannelReceiver batch2ProcessingChannelReceiver(IChannelFactory theChannelFactory) {
        ChannelConsumerSettings settings = new ChannelConsumerSettings().setConcurrentConsumers(this.getConcurrentConsumers());
        return theChannelFactory.getOrCreateReceiver(CHANNEL_NAME, JobWorkNotificationJsonMessage.class, settings);
    }

    @Bean
    public Batch2JobRegisterer batch2JobRegisterer() {
        return new Batch2JobRegisterer();
    }

    protected int getConcurrentConsumers() {
        return 4;
    }
}

