/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.api.IJobMaintenanceService;
import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.channel.BatchJobSender;
import ca.uhn.fhir.batch2.coordinator.BatchWorkChunk;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.coordinator.JobParameterJsonValidator;
import ca.uhn.fhir.batch2.coordinator.JobQuerySvc;
import ca.uhn.fhir.batch2.coordinator.WorkChannelMessageHandler;
import ca.uhn.fhir.batch2.coordinator.WorkChunkProcessor;
import ca.uhn.fhir.batch2.model.FetchJobInstancesRequest;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.batch2.model.JobWorkNotification;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.Logs;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.messaging.MessageHandler;

public class JobCoordinatorImpl
implements IJobCoordinator {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;
    private final BatchJobSender myBatchJobSender;
    private final IChannelReceiver myWorkChannelReceiver;
    private final JobDefinitionRegistry myJobDefinitionRegistry;
    private final MessageHandler myReceiverHandler;
    private final JobQuerySvc myJobQuerySvc;
    private final JobParameterJsonValidator myJobParameterJsonValidator;

    public JobCoordinatorImpl(@Nonnull BatchJobSender theBatchJobSender, @Nonnull IChannelReceiver theWorkChannelReceiver, @Nonnull IJobPersistence theJobPersistence, @Nonnull JobDefinitionRegistry theJobDefinitionRegistry, @Nonnull WorkChunkProcessor theExecutorSvc, @Nonnull IJobMaintenanceService theJobMaintenanceService) {
        Validate.notNull((Object)theJobPersistence);
        this.myJobPersistence = theJobPersistence;
        this.myBatchJobSender = theBatchJobSender;
        this.myWorkChannelReceiver = theWorkChannelReceiver;
        this.myJobDefinitionRegistry = theJobDefinitionRegistry;
        this.myReceiverHandler = new WorkChannelMessageHandler(theJobPersistence, theJobDefinitionRegistry, theBatchJobSender, theExecutorSvc, theJobMaintenanceService);
        this.myJobQuerySvc = new JobQuerySvc(theJobPersistence, theJobDefinitionRegistry);
        this.myJobParameterJsonValidator = new JobParameterJsonValidator();
    }

    @Override
    public Batch2JobStartResponse startInstance(JobInstanceStartRequest theStartRequest) {
        FetchJobInstancesRequest request;
        List<JobInstance> existing;
        JobDefinition<?> jobDefinition = this.myJobDefinitionRegistry.getLatestJobDefinition(theStartRequest.getJobDefinitionId()).orElseThrow(() -> new IllegalArgumentException(Msg.code((int)2063) + "Unknown job definition ID: " + theStartRequest.getJobDefinitionId()));
        String paramsString = theStartRequest.getParameters();
        if (StringUtils.isBlank((CharSequence)paramsString)) {
            throw new InvalidRequestException(Msg.code((int)2065) + "No parameters supplied");
        }
        if (theStartRequest.isUseCache() && !(existing = this.myJobPersistence.fetchInstances(request = new FetchJobInstancesRequest(theStartRequest.getJobDefinitionId(), theStartRequest.getParameters(), this.getStatesThatTriggerCache()), 0, 1000)).isEmpty()) {
            Collections.sort(existing, (o1, o2) -> -(o1.getStatus().ordinal() - o2.getStatus().ordinal()));
            JobInstance first = (JobInstance)existing.stream().findFirst().get();
            Batch2JobStartResponse response = new Batch2JobStartResponse();
            response.setJobId(first.getInstanceId());
            response.setUsesCachedResult(true);
            ourLog.info("Reusing cached {} job with status {} and id {}", new Object[]{first.getJobDefinitionId(), first.getStatus(), first.getInstanceId()});
            return response;
        }
        this.myJobParameterJsonValidator.validateJobParameters(theStartRequest, jobDefinition);
        JobInstance instance = JobInstance.fromJobDefinition(jobDefinition);
        instance.setParameters(theStartRequest.getParameters());
        instance.setStatus(StatusEnum.QUEUED);
        String instanceId = this.myJobPersistence.storeNewInstance(instance);
        ourLog.info("Stored new {} job {} with status {}", new Object[]{jobDefinition.getJobDefinitionId(), instanceId, instance.getStatus()});
        ourLog.debug("Job parameters: {}", (Object)instance.getParameters());
        BatchWorkChunk batchWorkChunk = BatchWorkChunk.firstChunk(jobDefinition, instanceId);
        String chunkId = this.myJobPersistence.storeWorkChunk(batchWorkChunk);
        JobWorkNotification workNotification = JobWorkNotification.firstStepNotification(jobDefinition, instanceId, chunkId);
        this.myBatchJobSender.sendWorkChannelMessage(workNotification);
        Batch2JobStartResponse response = new Batch2JobStartResponse();
        response.setJobId(instanceId);
        return response;
    }

    private StatusEnum[] getStatesThatTriggerCache() {
        return new StatusEnum[]{StatusEnum.QUEUED, StatusEnum.IN_PROGRESS};
    }

    @Override
    public JobInstance getInstance(String theInstanceId) {
        return this.myJobQuerySvc.fetchInstance(theInstanceId);
    }

    @Override
    public List<JobInstance> getInstances(int thePageSize, int thePageIndex) {
        return this.myJobQuerySvc.fetchInstances(thePageSize, thePageIndex);
    }

    @Override
    public List<JobInstance> getRecentInstances(int theCount, int theStart) {
        return this.myJobQuerySvc.fetchRecentInstances(theCount, theStart);
    }

    @Override
    public List<JobInstance> getInstancesbyJobDefinitionIdAndEndedStatus(String theJobDefinitionId, @Nullable Boolean theEnded, int theCount, int theStart) {
        return this.myJobQuerySvc.getInstancesByJobDefinitionIdAndEndedStatus(theJobDefinitionId, theEnded, theCount, theStart);
    }

    @Override
    public List<JobInstance> getJobInstancesByJobDefinitionIdAndStatuses(String theJobDefinitionId, Set<StatusEnum> theStatuses, int theCount, int theStart) {
        return this.myJobQuerySvc.getInstancesByJobDefinitionAndStatuses(theJobDefinitionId, theStatuses, theCount, theStart);
    }

    @Override
    public List<JobInstance> getJobInstancesByJobDefinitionId(String theJobDefinitionId, int theCount, int theStart) {
        return this.getJobInstancesByJobDefinitionIdAndStatuses(theJobDefinitionId, new HashSet<StatusEnum>(Arrays.asList(StatusEnum.values())), theCount, theStart);
    }

    @Override
    public Page<JobInstance> fetchAllJobInstances(JobInstanceFetchRequest theFetchRequest) {
        return this.myJobQuerySvc.fetchAllInstances(theFetchRequest);
    }

    @Override
    public JobOperationResultJson cancelInstance(String theInstanceId) throws ResourceNotFoundException {
        return this.myJobPersistence.cancelInstance(theInstanceId);
    }

    @PostConstruct
    public void start() {
        this.myWorkChannelReceiver.subscribe(this.myReceiverHandler);
    }

    @PreDestroy
    public void stop() {
        this.myWorkChannelReceiver.unsubscribe(this.myReceiverHandler);
    }
}

