/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobDefinitionStep;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class JobDefinitionRegistry {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private volatile Map<String, NavigableMap<Integer, JobDefinition<?>>> myJobs = new HashMap();

    public synchronized <PT extends IModelJson> boolean addJobDefinitionIfNotRegistered(@Nonnull JobDefinition<PT> theDefinition) {
        Optional<JobDefinition<?>> orig = this.getJobDefinition(theDefinition.getJobDefinitionId(), theDefinition.getJobDefinitionVersion());
        if (orig.isPresent()) {
            return false;
        }
        this.addJobDefinition(theDefinition);
        return true;
    }

    public synchronized <PT extends IModelJson> void addJobDefinition(@Nonnull JobDefinition<PT> theDefinition) {
        Validate.notNull(theDefinition);
        String jobDefinitionId = theDefinition.getJobDefinitionId();
        Validate.notBlank((CharSequence)jobDefinitionId);
        Validate.isTrue((theDefinition.getJobDefinitionVersion() >= 1 ? 1 : 0) != 0);
        Validate.isTrue((theDefinition.getSteps().size() > 1 ? 1 : 0) != 0);
        HashSet<String> stepIds = new HashSet<String>();
        for (JobDefinitionStep<PT, ?, ?> next : theDefinition.getSteps()) {
            if (stepIds.add(next.getStepId())) continue;
            throw new ConfigurationException(Msg.code((int)2046) + "Duplicate step[" + next.getStepId() + "] in definition[" + jobDefinitionId + "] version: " + theDefinition.getJobDefinitionVersion());
        }
        Map<String, NavigableMap<Integer, JobDefinition<?>>> newJobsMap = this.cloneJobsMap();
        NavigableMap versionMap = newJobsMap.computeIfAbsent(jobDefinitionId, t -> new TreeMap());
        if (versionMap.containsKey(theDefinition.getJobDefinitionVersion())) {
            if (versionMap.get(theDefinition.getJobDefinitionVersion()) == theDefinition) {
                ourLog.warn("job[{}] version: {} already registered.  Not registering again.", (Object)jobDefinitionId, (Object)theDefinition.getJobDefinitionVersion());
                return;
            }
            throw new ConfigurationException(Msg.code((int)2047) + "Multiple definitions for job[" + jobDefinitionId + "] version: " + theDefinition.getJobDefinitionVersion());
        }
        versionMap.put(theDefinition.getJobDefinitionVersion(), theDefinition);
        this.myJobs = newJobsMap;
    }

    public synchronized void removeJobDefinition(@Nonnull String theDefinitionId, int theVersion) {
        Validate.notBlank((CharSequence)theDefinitionId);
        Validate.isTrue((theVersion >= 1 ? 1 : 0) != 0);
        Map<String, NavigableMap<Integer, JobDefinition<?>>> newJobsMap = this.cloneJobsMap();
        NavigableMap<Integer, JobDefinition<?>> versionMap = newJobsMap.get(theDefinitionId);
        if (versionMap != null) {
            versionMap.remove(theVersion);
            if (versionMap.isEmpty()) {
                newJobsMap.remove(theDefinitionId);
            }
        }
        this.myJobs = newJobsMap;
    }

    @Nonnull
    private Map<String, NavigableMap<Integer, JobDefinition<?>>> cloneJobsMap() {
        HashMap newJobsMap = new HashMap();
        for (Map.Entry<String, NavigableMap<Integer, JobDefinition<?>>> nextEntry : this.myJobs.entrySet()) {
            newJobsMap.put(nextEntry.getKey(), new TreeMap(nextEntry.getValue()));
        }
        return newJobsMap;
    }

    public Optional<JobDefinition<?>> getLatestJobDefinition(@Nonnull String theJobDefinitionId) {
        NavigableMap<Integer, JobDefinition<?>> versionMap = this.myJobs.get(theJobDefinitionId);
        if (versionMap == null || versionMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(versionMap.lastEntry().getValue());
    }

    public Optional<JobDefinition<?>> getJobDefinition(@Nonnull String theJobDefinitionId, int theJobDefinitionVersion) {
        NavigableMap<Integer, JobDefinition<?>> versionMap = this.myJobs.get(theJobDefinitionId);
        if (versionMap == null || versionMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((JobDefinition)versionMap.get(theJobDefinitionVersion));
    }

    public JobDefinition<?> getJobDefinitionOrThrowException(String theJobDefinitionId, int theJobDefinitionVersion) {
        Optional<JobDefinition<?>> opt = this.getJobDefinition(theJobDefinitionId, theJobDefinitionVersion);
        if (opt.isEmpty()) {
            String msg = "Unknown job definition ID[" + theJobDefinitionId + "] version[" + theJobDefinitionVersion + "]";
            ourLog.warn(msg);
            throw new JobExecutionFailedException(Msg.code((int)2043) + msg);
        }
        return opt.get();
    }

    public void setJobDefinition(JobInstance theInstance) {
        JobDefinition<?> jobDefinition = this.getJobDefinitionOrThrowException(theInstance);
        theInstance.setJobDefinition(jobDefinition);
    }

    public List<String> getJobDefinitionIds() {
        return this.myJobs.keySet().stream().sorted().collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.myJobs.isEmpty();
    }

    public Optional<JobDefinition<?>> getJobDefinition(JobInstance theJobInstance) {
        return this.getJobDefinition(theJobInstance.getJobDefinitionId(), theJobInstance.getJobDefinitionVersion());
    }

    public JobDefinition<?> getJobDefinitionOrThrowException(JobInstance theJobInstance) {
        return this.getJobDefinitionOrThrowException(theJobInstance.getJobDefinitionId(), theJobInstance.getJobDefinitionVersion());
    }

    public Collection<Integer> getJobDefinitionVersions(String theDefinitionId) {
        return ((NavigableMap)this.myJobs.getOrDefault(theDefinitionId, (NavigableMap<Integer, JobDefinition<?>>)ImmutableSortedMap.of())).keySet();
    }
}

