/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.coordinator.BaseDataSink;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.JobWorkCursor;
import ca.uhn.fhir.batch2.model.WorkChunkData;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.Logs;
import java.util.Optional;
import org.slf4j.Logger;

public class ReductionStepDataSink<PT extends IModelJson, IT extends IModelJson, OT extends IModelJson>
extends BaseDataSink<PT, IT, OT> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;

    protected ReductionStepDataSink(String theInstanceId, JobWorkCursor<PT, IT, OT> theJobWorkCursor, JobDefinition<PT> theDefinition, IJobPersistence thePersistence) {
        super(theInstanceId, theJobWorkCursor);
        this.myJobPersistence = thePersistence;
    }

    @Override
    public void accept(WorkChunkData<OT> theData) {
        JobInstance instance;
        String instanceId = this.getInstanceId();
        Optional<JobInstance> instanceOp = this.myJobPersistence.fetchInstance(instanceId);
        if (instanceOp.isPresent()) {
            instance = instanceOp.get();
            if (instance.getReport() != null) {
                ourLog.error("Report has already been set. Now it is being overwritten. Last in will win!");
            }
        } else {
            String msg = "No instance found with Id " + instanceId;
            ourLog.error(msg);
            throw new JobExecutionFailedException(Msg.code((int)2097) + msg);
        }
        OT data = theData.getData();
        String dataString = JsonUtil.serialize(data, (boolean)false);
        instance.setReport(dataString);
        ourLog.debug(JsonUtil.serialize((Object)instance));
        this.myJobPersistence.updateInstance(instance);
    }

    @Override
    public int getWorkChunkCount() {
        return 0;
    }
}

