/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.JobStepFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.coordinator.BaseDataSink;
import ca.uhn.fhir.batch2.model.MarkWorkChunkAsErrorRequest;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class StepExecutor {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;

    public StepExecutor(IJobPersistence theJobPersistence) {
        this.myJobPersistence = theJobPersistence;
    }

    <PT extends IModelJson, IT extends IModelJson, OT extends IModelJson> boolean executeStep(StepExecutionDetails<PT, IT> theStepExecutionDetails, IJobStepWorker<PT, IT, OT> theStepWorker, BaseDataSink<PT, IT, OT> theDataSink) {
        RunOutcome outcome;
        String jobDefinitionId = theDataSink.getJobDefinitionId();
        String targetStepId = theDataSink.getTargetStep().getStepId();
        String chunkId = theStepExecutionDetails.getChunkId();
        try {
            outcome = theStepWorker.run(theStepExecutionDetails, theDataSink);
            Validate.notNull((Object)outcome, (String)"Step theWorker returned null: %s", (Object[])new Object[]{theStepWorker.getClass()});
        }
        catch (JobExecutionFailedException e) {
            ourLog.error("Unrecoverable failure executing job {} step {} chunk {}", new Object[]{jobDefinitionId, targetStepId, chunkId, e});
            if (theStepExecutionDetails.hasAssociatedWorkChunk()) {
                this.myJobPersistence.markWorkChunkAsFailed(chunkId, e.toString());
            }
            return false;
        }
        catch (Exception e) {
            if (theStepExecutionDetails.hasAssociatedWorkChunk()) {
                WorkChunk chunk;
                ourLog.error("Failure executing job {} step {}, marking chunk {} as ERRORED", new Object[]{jobDefinitionId, targetStepId, chunkId, e});
                MarkWorkChunkAsErrorRequest parameters = new MarkWorkChunkAsErrorRequest();
                parameters.setChunkId(chunkId);
                parameters.setErrorMsg(e.getMessage());
                Optional<WorkChunk> updatedOp = this.myJobPersistence.markWorkChunkAsErroredAndIncrementErrorCount(parameters);
                if (updatedOp.isPresent() && (chunk = updatedOp.get()).getErrorCount() > 3) {
                    String errorMsg = "Too many errors: " + chunk.getErrorCount() + ". Last error msg was " + e.getMessage();
                    this.myJobPersistence.markWorkChunkAsFailed(chunkId, errorMsg);
                    return false;
                }
            } else {
                ourLog.error("Failure executing job {} step {}, no associated work chunk", new Object[]{jobDefinitionId, targetStepId, e});
            }
            throw new JobStepFailedException(Msg.code((int)2041) + e.getMessage(), e);
        }
        catch (Throwable t) {
            ourLog.error("Unexpected failure executing job {} step {}", new Object[]{jobDefinitionId, targetStepId, t});
            if (theStepExecutionDetails.hasAssociatedWorkChunk()) {
                this.myJobPersistence.markWorkChunkAsFailed(chunkId, t.toString());
            }
            return false;
        }
        if (theStepExecutionDetails.hasAssociatedWorkChunk()) {
            int recordsProcessed = outcome.getRecordsProcessed();
            int recoveredErrorCount = theDataSink.getRecoveredErrorCount();
            this.myJobPersistence.markWorkChunkAsCompletedAndClearData(chunkId, recordsProcessed);
            if (recoveredErrorCount > 0) {
                this.myJobPersistence.incrementWorkChunkErrorCount(chunkId, recoveredErrorCount);
            }
        }
        return true;
    }
}

